/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam.audio.impl;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.handler.ffmpeg.ExecutableLocator;
import com.day.cq.dam.handler.ffmpeg.FFMpegWrapper;
import com.day.cq.dam.handler.ffmpeg.FfmpegNotFoundException;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true, metatype=true)
public abstract class AbstractFFMpegAudioProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(AbstractFFMpegAudioProcess.class);
    @Property(value={"./logs/ffmpeg"})
    public static final String PROP_WORKING_DIR = "ffmpeg.workingdir";
    @Reference(policy=ReferencePolicy.STATIC)
    private ExecutableLocator locator;
    private File workingDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void execute(WorkItem workItem, WorkflowSession wfSession, MetaDataMap metaData) throws WorkflowException {
        Asset asset = this.getAssetFromPayload(workItem, wfSession.getSession());
        if (asset == null) {
            String wfPayload = workItem.getWorkflowData().getPayload().toString();
            String message = "execute: cannot process audio, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
            throw new WorkflowException(message);
        }
        String assetMimeType = asset.getMimeType();
        if (!(assetMimeType != null && assetMimeType.startsWith("audio/") || asset.getName().endsWith(".wav") && asset.getName().endsWith(".mp3") && asset.getName().endsWith(".ogg"))) {
            log.info("execute: asset [{}] is not of a audio mime type, asset ignored.", (Object)asset.getPath());
            return;
        }
        File tmpDir = null;
        File tmpWorkingDir = null;
        FileOutputStream fos = null;
        InputStream is = null;
        FFMpegWrapper wrapper = null;
        try {
            tmpDir = this.createTempDir(null);
            tmpWorkingDir = this.createTempDir(this.getWorkingDir());
            File tmpFile = new File(tmpDir, asset.getName().replace(' ', '_'));
            fos = new FileOutputStream(tmpFile);
            is = asset.getOriginal().getStream();
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            this.processAudio(metaData, asset, tmpFile, wfSession);
            wrapper = new FFMpegWrapper(tmpFile, tmpWorkingDir);
            wrapper.setExecutableLocator(this.locator);
            ResourceResolver resolver = this.getResourceResolver(wfSession.getSession());
            Resource assetResource = (Resource)asset.adaptTo(Resource.class);
            Resource metadata = resolver.getResource(assetResource, "jcr:content/metadata");
            if (null != metadata) {
                Node metadataNode = (Node)metadata.adaptTo(Node.class);
                metadataNode.setProperty("dc:extent", wrapper.getInputDuration());
                metadataNode.getSession().save();
            } else {
                log.warn("execute: failed setting metdata for asset [{}] in workflow [{}], no metdata node found.", (Object)asset.getPath(), (Object)workItem.getId());
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        catch (IOException e) {
            throw new WorkflowException((Throwable)e);
            catch (RepositoryException e2) {
                throw new WorkflowException((Throwable)e2);
            }
            catch (FfmpegNotFoundException e3) {
                log.error(e3.getMessage(), (Throwable)e3);
                return;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
        try {
            if (tmpDir != null) {
                FileUtils.deleteDirectory((File)tmpDir);
            }
        }
        catch (IOException e) {
            log.error("Could not delete temp directory: {}", (Object)tmpDir.getPath());
            throw new WorkflowException((Throwable)e);
        }
        try {
            if (tmpWorkingDir == null) return;
            FileUtils.deleteDirectory((File)tmpWorkingDir);
            return;
        }
        catch (IOException e) {
            log.warn("Could not delete ffmpeg's temporary working directory: {}", (Object)tmpWorkingDir.getPath());
            return;
        }
        finally {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(fos);
            try {
                if (tmpDir != null) {
                    FileUtils.deleteDirectory((File)tmpDir);
                }
            }
            catch (IOException e) {
                log.error("Could not delete temp directory: {}", (Object)tmpDir.getPath());
                throw new WorkflowException((Throwable)e);
            }
            try {
                if (tmpWorkingDir != null) {
                    FileUtils.deleteDirectory((File)tmpWorkingDir);
                }
            }
            catch (IOException e) {
                log.warn("Could not delete ffmpeg's temporary working directory: {}", (Object)tmpWorkingDir.getPath());
            }
        }
    }

    protected final ExecutableLocator getLocator() {
        return this.locator;
    }

    protected final File getWorkingDir() throws IOException {
        if (!this.workingDir.exists() && !this.workingDir.mkdir()) {
            throw new IOException("Working directory could not be created.");
        }
        return this.workingDir;
    }

    private static File resolveWorkingDir(String slingHome, String path) {
        File workingDir;
        if (path == null) {
            path = "";
        }
        if (!(workingDir = new File(path = path.replace('/', File.separatorChar))).isAbsolute()) {
            File baseDir = slingHome == null ? new File("").getAbsoluteFile() : new File(slingHome).getAbsoluteFile();
            workingDir = new File(baseDir, path).getAbsoluteFile();
        }
        try {
            log.info("ffmpeg working directory: {}", (Object)workingDir.getCanonicalPath());
        }
        catch (IOException e) {
            log.info("ffmpeg working directory: {}", (Object)workingDir.getAbsolutePath());
        }
        return workingDir;
    }

    protected final void activate(ComponentContext ctx) {
        String slingHome = ctx.getBundleContext().getProperty("sling.home");
        this.workingDir = AbstractFFMpegAudioProcess.resolveWorkingDir(slingHome, (String)ctx.getProperties().get(PROP_WORKING_DIR));
    }

    protected final File createTempDir(File parentDir) throws IOException {
        File tempDir = null;
        try {
            tempDir = File.createTempFile("cqdam", null, parentDir);
            if (!tempDir.delete()) {
                throw new IOException("Unable to delete temp directory.");
            }
            if (!tempDir.mkdir()) {
                throw new IOException("Unable to create temp directory.");
            }
        }
        catch (IOException e) {
            log.warn("could not create temp directory in the [{}] with the exception", (Object)parentDir, (Object)e);
        }
        return tempDir;
    }

    protected abstract void processAudio(MetaDataMap var1, Asset var2, File var3, WorkflowSession var4) throws IOException, RepositoryException;

    protected void bindLocator(ExecutableLocator executableLocator) {
        this.locator = executableLocator;
    }

    protected void unbindLocator(ExecutableLocator executableLocator) {
        if (this.locator == executableLocator) {
            this.locator = null;
        }
    }
}

