/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam;

import aQute.bnd.annotation.ConsumerType;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.commons.util.PrefixRenditionPicker;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.image.Layer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.IIOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConsumerType
public abstract class AbstractRenditionModifyingProcess
extends AbstractAssetWorkflowProcess {
    private static final int MAX_GIF_QUALITY = 255;
    private static final String DEFAULT_QUALITY = "60";
    private static final int MAX_GENERIC_QUALITY = 100;
    private static final String ARG_QUALITY = "quality";
    private static final String ARG_RENDITION_NAME = "renditionName";
    private static final Logger log = LoggerFactory.getLogger(AbstractRenditionModifyingProcess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        String qualityStr;
        String[] args = this.buildArguments(metaData);
        String renditionName = this.getValuesFromArgs(ARG_RENDITION_NAME, args).size() > 0 ? (String)this.getValuesFromArgs(ARG_RENDITION_NAME, args).get(0) : null;
        String string = qualityStr = this.getValuesFromArgs(ARG_QUALITY, args).size() > 0 ? (String)this.getValuesFromArgs(ARG_QUALITY, args).get(0) : DEFAULT_QUALITY;
        if (renditionName == null) {
            log.warn("Rendition name was not configured in arguments. Skipping.");
            return;
        }
        Asset asset = this.getAssetFromPayload(workItem, workflowSession.getSession());
        Rendition rendition = asset.getRendition((RenditionPicker)new PrefixRenditionPicker(renditionName));
        if (rendition == null) {
            log.warn("Rendition name {} was not available for asset {}. Skipping.", (Object)renditionName, (Object)asset);
            return;
        }
        Layer layer = null;
        try {
            layer = new Layer(rendition.getStream());
            layer = this.processLayer(layer, rendition, workflowSession, args);
            String mimetype = layer.getMimeType();
            double quality = mimetype.equals("image/gif") ? this.getQuality(255.0, qualityStr) : this.getQuality(1.0, qualityStr);
            this.saveImage(asset, rendition, layer, mimetype, quality);
        }
        catch (IIOException e) {
            log.warn("Unable to load image layer from " + rendition.getPath(), (Throwable)e);
        }
        catch (IOException e) {
            log.warn("Unable to load image layer from " + rendition.getPath(), (Throwable)e);
        }
        finally {
            if (layer != null) {
                layer.dispose();
                layer = null;
            }
        }
    }

    private String[] buildArguments(MetaDataMap metaData) {
        String processArgs = (String)metaData.get("PROCESS_ARGS", String.class);
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveImage(Asset asset, Rendition toReplace, Layer layer, String mimetype, double quality) throws IOException {
        File tmpFile = File.createTempFile(this.getTempFileSpecifier(), "." + this.getExtension(mimetype));
        FileOutputStream out = FileUtils.openOutputStream((File)tmpFile);
        FileInputStream is = null;
        try {
            layer.write(mimetype, quality, (OutputStream)out);
            is = FileUtils.openInputStream((File)tmpFile);
            asset.addRendition(toReplace.getName(), (InputStream)is, mimetype);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly(is);
            FileUtils.deleteQuietly((File)tmpFile);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)is);
        FileUtils.deleteQuietly((File)tmpFile);
    }

    protected final String getExtension(String mimetype) {
        return this.mimeTypeService.getExtension(mimetype);
    }

    protected final double getQuality(double base, String qualityStr) {
        int q = Integer.parseInt(qualityStr);
        double res = base * (double)q / 100.0;
        return res;
    }

    protected abstract String getTempFileSpecifier();

    protected abstract Layer processLayer(Layer var1, Rendition var2, WorkflowSession var3, String[] var4);
}

