/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.components.longformtext.impl;

import com.adobe.acs.commons.components.longformtext.LongFormTextComponent;
import com.day.cq.commons.jcr.JcrUtil;
import java.security.AccessControlException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.html.HtmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

@Component
@Service
public class LongFormTextComponentImpl
implements LongFormTextComponent {
    private static final Logger log = LoggerFactory.getLogger(LongFormTextComponentImpl.class);
    @Reference
    private HtmlParser htmlParser;

    @Override
    public final String[] getTextParagraphs(String text) {
        ArrayList<String> paragraphs = new ArrayList<String>();
        try {
            Document doc = this.htmlParser.parse(null, IOUtils.toInputStream((String)text), "UTF-8");
            doc.getDocumentElement().normalize();
            DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)doc.getImplementation());
            LSSerializer lsSerializer = domImplementation.createLSSerializer();
            lsSerializer.getDomConfig().setParameter("xml-declaration", false);
            lsSerializer.getDomConfig().setParameter("namespaces", false);
            NodeList bodies = doc.getElementsByTagName("body");
            if (bodies != null && bodies.getLength() == 1) {
                Node body = bodies.item(0);
                NodeList children = body.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (child == null) {
                        log.warn("Found a null dom node.");
                        continue;
                    }
                    if (child.getNodeType() != 1) {
                        log.warn("Found a dom node is not an element; skipping");
                        continue;
                    }
                    String outerHTML = lsSerializer.writeToString(child);
                    if (!StringUtils.isNotBlank((String)outerHTML)) continue;
                    paragraphs.add(outerHTML);
                }
            } else {
                log.debug("HTML does not have a single body tag. Cannot parse as expected.");
            }
        }
        catch (Exception e) {
            log.warn("Long Form Text encountered a parser error: {}", (Throwable)e);
        }
        return paragraphs.toArray(new String[paragraphs.size()]);
    }

    @Override
    public final void mergeParagraphSystems(Resource resource, int textParagraphSize) throws RepositoryException {
        if (resource == null || ResourceUtil.isNonExistingResource((Resource)resource) || !this.isModifiable(resource)) {
            return;
        }
        javax.jcr.Node targetNode = this.getOrCreateLastParagraphSystemResource(resource, textParagraphSize);
        if (targetNode == null) {
            log.info("Could not find last target node to merge long-form-text text inline par resources: {}", (Object)textParagraphSize);
            return;
        }
        for (Resource child : resource.getChildren()) {
            int index = this.getResourceIndex(child);
            if (index <= textParagraphSize) continue;
            this.moveChildrenToNode(child, targetNode);
        }
    }

    @Override
    public boolean hasContents(Resource resource, int index) {
        Resource parResource = resource.getChild("long-form-text-par-" + index);
        return parResource != null && parResource.listChildren().hasNext();
    }

    private void moveChildrenToNode(Resource resource, javax.jcr.Node targetNode) throws RepositoryException {
        for (Resource child : resource.getChildren()) {
            javax.jcr.Node uniqueNode = JcrUtil.createUniqueNode((javax.jcr.Node)targetNode, (String)child.getName(), (String)"nt:unstructured", (Session)targetNode.getSession());
            JcrUtil.copy((javax.jcr.Node)((javax.jcr.Node)child.adaptTo(javax.jcr.Node.class)), (javax.jcr.Node)targetNode, (String)uniqueNode.getName(), (boolean)true);
        }
        ((javax.jcr.Node)resource.adaptTo(javax.jcr.Node.class)).remove();
        targetNode.getSession().save();
    }

    private javax.jcr.Node getOrCreateLastParagraphSystemResource(Resource resource, int lastIndex) throws RepositoryException {
        String resourceName = "long-form-text-par-" + lastIndex;
        Resource lastResource = resource.getChild(resourceName);
        if (lastResource != null) {
            return (javax.jcr.Node)lastResource.adaptTo(javax.jcr.Node.class);
        }
        javax.jcr.Node parentNode = (javax.jcr.Node)resource.adaptTo(javax.jcr.Node.class);
        if (parentNode == null) {
            return null;
        }
        Session session = parentNode.getSession();
        javax.jcr.Node node = JcrUtil.createPath((javax.jcr.Node)parentNode, (String)resourceName, (boolean)false, (String)"nt:unstructured", (String)"nt:unstructured", (Session)session, (boolean)true);
        return node;
    }

    private int getResourceIndex(Resource resource) {
        String resourceName = resource.getName();
        if (!StringUtils.startsWith((String)resourceName, (String)"long-form-text-par-")) {
            return -1;
        }
        String indexStr = StringUtils.removeStart((String)resourceName, (String)"long-form-text-par-");
        try {
            return Integer.parseInt(indexStr);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private boolean isModifiable(Resource resource) throws RepositoryException {
        String writePermissions = "add_node,set_property,remove";
        Session userSession = (Session)resource.getResourceResolver().adaptTo(Session.class);
        String path = resource.getPath();
        try {
            userSession.checkPermission(path, "add_node,set_property,remove");
        }
        catch (AccessControlException e) {
            log.debug("User does not have modify permissions [ {} ] on [ {} ]", (Object)"add_node,set_property,remove", (Object)resource.getPath());
            return false;
        }
        return true;
    }

    protected void bindHtmlParser(HtmlParser htmlParser) {
        this.htmlParser = htmlParser;
    }

    protected void unbindHtmlParser(HtmlParser htmlParser) {
        if (this.htmlParser == htmlParser) {
            this.htmlParser = null;
        }
    }
}

