/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.analysis.jcrchecksum.impl;

import aQute.bnd.annotation.ProviderType;
import com.adobe.acs.commons.analysis.jcrchecksum.ChecksumGenerator;
import com.adobe.acs.commons.analysis.jcrchecksum.ChecksumGeneratorOptions;
import com.adobe.acs.commons.analysis.jcrchecksum.impl.options.DefaultChecksumGeneratorOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public final class JSONGenerator {
    private static final Logger log = LoggerFactory.getLogger(ChecksumGenerator.class);

    private JSONGenerator() {
    }

    public static void generateJSON(Session session, String path, JSONWriter out) throws RepositoryException, JSONException {
        HashSet<String> paths = new HashSet<String>();
        paths.add(path);
        JSONGenerator.generateJSON(session, paths, new DefaultChecksumGeneratorOptions(), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateJSON(Session session, Set<String> paths, ChecksumGeneratorOptions opts, JSONWriter out) throws RepositoryException, JSONException {
        Node node = null;
        if (paths.size() > 1) {
            out.array();
        }
        for (String path : paths) {
            out.object();
            try {
                Item item;
                if (session.itemExists(path) && (item = session.getItem(path)).isNode()) {
                    node = (Node)item;
                }
                JSONGenerator.traverseTree(node, opts, out);
            }
            catch (PathNotFoundException e) {
                out.key("ERROR");
                out.value((Object)("WARN: Path doesn't exist: " + path));
            }
            catch (RepositoryException e) {
                out.key("ERROR");
                out.value((Object)("Unable to read path: " + e.getMessage()));
            }
            finally {
                out.endObject();
            }
        }
        if (paths.size() > 1) {
            out.endArray();
        }
    }

    private static void traverseTree(Node node, ChecksumGeneratorOptions opts, JSONWriter out) throws JSONException {
        Set<String> nodeTypes = opts.getIncludedNodeTypes();
        Set<String> nodeTypeExcludes = opts.getExcludedNodeTypes();
        if (node != null) {
            try {
                String primaryNodeType = node.getPrimaryNodeType().getName();
                if (nodeTypes.contains(primaryNodeType) && !nodeTypeExcludes.contains(primaryNodeType)) {
                    JSONGenerator.generateJSON(node, opts, out);
                } else {
                    NodeIterator nIt = node.getNodes();
                    while (nIt.hasNext()) {
                        primaryNodeType = node.getPrimaryNodeType().getName();
                        Node child = nIt.nextNode();
                        if (nodeTypes.contains(primaryNodeType)) {
                            JSONGenerator.generateJSON(child, opts, out);
                            continue;
                        }
                        JSONGenerator.traverseTree(child, opts, out);
                    }
                }
            }
            catch (RepositoryException e) {
                log.error("Error while traversing tree {}", (Object)e.getMessage());
            }
        }
    }

    private static void generateJSON(Node node, ChecksumGeneratorOptions opts, JSONWriter out) throws RepositoryException, JSONException {
        out.key(node.getPath());
        out.object();
        JSONGenerator.outputProperties(node, opts, out);
        JSONGenerator.outputChildNodes(node, opts, out);
        out.endObject();
    }

    private static void generateSubnodeJSON(Node node, ChecksumGeneratorOptions opts, JSONWriter out) throws RepositoryException, JSONException {
        out.key(node.getName());
        out.object();
        JSONGenerator.outputProperties(node, opts, out);
        JSONGenerator.outputChildNodes(node, opts, out);
        out.endObject();
    }

    private static void outputProperties(Node node, ChecksumGeneratorOptions opts, JSONWriter out) throws RepositoryException, JSONException, ValueFormatException {
        Set<String> excludes = opts.getExcludedProperties();
        Set<String> sortValues = opts.getSortedProperties();
        TreeMap<String, Property> props = new TreeMap<String, Property>();
        PropertyIterator pi = node.getProperties();
        while (pi.hasNext()) {
            Property p = pi.nextProperty();
            if (excludes.contains(p.getName())) continue;
            props.put(p.getName(), p);
        }
        pi = null;
        for (Property p : props.values()) {
            int type = p.getType();
            if (p.isMultiple()) {
                out.key(p.getName());
                out.array();
                boolean isSortedValues = sortValues.contains(p.getName());
                Value[] values = p.getValues();
                TreeMap<String, Value> sortedValueMap = new TreeMap<String, Value>();
                for (Value v : values) {
                    type = v.getType();
                    if (type == 2) {
                        if (isSortedValues) {
                            try {
                                InputStream stream = v.getBinary().getStream();
                                String ckSum = DigestUtils.shaHex((InputStream)stream);
                                stream.close();
                                sortedValueMap.put(ckSum, v);
                            }
                            catch (IOException e) {
                                sortedValueMap.put("ERROR: generating hash for binary of " + p.getPath() + " : " + e.getMessage(), v);
                            }
                            continue;
                        }
                        JSONGenerator.outputPropertyValue(p, v, out);
                        continue;
                    }
                    String val = v.getString();
                    if (isSortedValues) {
                        sortedValueMap.put(val, v);
                        continue;
                    }
                    JSONGenerator.outputPropertyValue(p, v, out);
                }
                if (isSortedValues) {
                    for (Value v : sortedValueMap.values()) {
                        JSONGenerator.outputPropertyValue(p, v, out);
                    }
                }
                out.endArray();
                continue;
            }
            out.key(p.getName());
            JSONGenerator.outputPropertyValue(p, p.getValue(), out);
        }
    }

    private static void outputChildNodes(Node node, ChecksumGeneratorOptions opts, JSONWriter out) throws RepositoryException, JSONException {
        Set<String> nodeTypeExcludes = opts.getExcludedNodeTypes();
        NodeIterator nIt = node.getNodes();
        TreeMap<String, Node> childSortMap = new TreeMap<String, Node>();
        boolean hasOrderedChildren = false;
        try {
            hasOrderedChildren = node.getPrimaryNodeType().hasOrderableChildNodes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (nIt.hasNext()) {
            Node child = nIt.nextNode();
            if (nodeTypeExcludes.contains(child.getPrimaryNodeType().getName())) continue;
            if (hasOrderedChildren) {
                out.key(child.getName());
                out.object();
                JSONGenerator.generateSubnodeJSON(child, opts, out);
                out.endObject();
                continue;
            }
            childSortMap.put(child.getName(), child);
        }
        for (Node child : childSortMap.values()) {
            out.key(child.getName());
            out.object();
            JSONGenerator.generateSubnodeJSON(child, opts, out);
            out.endObject();
        }
    }

    private static void outputPropertyValue(Property p, Value v, JSONWriter out) throws RepositoryException, JSONException {
        if (v.getType() == 1) {
            out.value((Object)v.getString());
        } else if (v.getType() == 2) {
            try {
                InputStream stream = v.getBinary().getStream();
                String ckSum = DigestUtils.shaHex((InputStream)stream);
                stream.close();
                out.value((Object)ckSum);
            }
            catch (IOException e) {
                out.value((Object)("ERROR: calculating hash for binary of " + p.getPath() + " : " + e.getMessage()));
            }
        } else if (v.getType() == 6) {
            out.value(v.getBoolean());
        } else if (v.getType() == 5) {
            Calendar cal = v.getDate();
            if (cal != null) {
                out.object();
                out.key("type");
                out.value((Object)PropertyType.nameFromValue((int)v.getType()));
                out.key("val");
                out.value((Object)cal.getTime().toString());
                out.endObject();
            }
        } else if (v.getType() == 3) {
            out.value(v.getLong());
        } else if (v.getType() == 4) {
            out.value(v.getDouble());
        } else if (v.getType() == 12) {
            out.value((Object)v.getDecimal());
        } else {
            out.object();
            out.key("type");
            out.value((Object)PropertyType.nameFromValue((int)v.getType()));
            out.key("val");
            out.value((Object)v.getString());
            out.endObject();
        }
    }
}

