/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.adobe.acs.commons.wcm.AuthorUIHelper;
import com.day.cq.commons.Externalizer;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;

@Component(label="ACS AEM Commons - Author UI Helper", description="Helper service to maintain a central configuration related to which authoring environment is being used (touch vs classic).", metatype=true)
@Service
public class AuthorUIHelperImpl
implements AuthorUIHelper {
    @Reference
    private Externalizer externalizer;
    private static final String WCM_EDITOR_URL_TOUCH_DEFAULT = "/editor.html";
    private static final String WCM_EDITOR_URL_CLASSIC_DEFAULT = "/cf#";
    private static final String DAM_EDITOR_URL_TOUCH_DEFAULT = "/assetdetails.html";
    private static final String DAM_EDITOR_URL_CLASSIC_DEFAULT = "/damadmin#";
    private static final boolean DEFAULT_TOUCH_UI = true;
    @Property(label="Touch UI Authoring", description="Indicates whether the touch UI is being used as the primary authoring environment", boolValue={true})
    private static final String TOUCH_UI = "isTouch";
    private boolean isTouch = true;
    @Property(label="Touch UI Page Editor", description="URL of the page editor used when authoring UI mode is Touch-Optimized", value={"/editor.html"})
    public static final String WCM_EDITOR_URL_TOUCH = "wcmEditorTouchURL";
    private String wcmEditorTouchUrl = "/editor.html";
    @Property(label="Classic UI Page Editor", description="URL of the page editor used when authoring UI mode is Classic", value={"/cf#"})
    public static final String WCM_EDITOR_URL_CLASSIC = "wcmEditorClassicURL";
    private String wcmEditorClassicUrl = "/cf#";
    @Property(label="Touch UI Asset Editor", description="URL of the asset editor used when authoring UI mode is Touch-Optimized", value={"/assetdetails.html"})
    public static final String DAM_EDITOR_URL_TOUCH = "damEditorTouchURL";
    private String damEditorTouchUrl = "/assetdetails.html";
    @Property(label="Classic UI Asset Editor", description="URL of the asset editor used when authoring UI mode is Classic", value={"/damadmin#"})
    public static final String DAM_EDITOR_URL_CLASSIC = "damEditorClassicURL";
    private String damEditorClassicUrl = "/damadmin#";

    @Override
    public boolean isTouchUI() {
        return this.isTouch;
    }

    @Override
    public String generateEditPageLink(String pagePath, boolean absoluteUrl, ResourceResolver resolver) {
        String pageUrl = this.isTouch ? this.wcmEditorTouchUrl + pagePath + ".html" : this.wcmEditorClassicUrl + pagePath + ".html";
        if (absoluteUrl) {
            pageUrl = this.externalizer.authorLink(resolver, pageUrl);
        }
        return pageUrl;
    }

    @Override
    public String generateEditAssetLink(String assetPath, boolean absoluteUrl, ResourceResolver resolver) {
        String assetUrl = this.isTouch ? this.damEditorTouchUrl + assetPath : this.damEditorClassicUrl + assetPath;
        if (absoluteUrl) {
            assetUrl = this.externalizer.authorLink(resolver, assetUrl);
        }
        return assetUrl;
    }

    private void configure(Map<String, String> config) {
        this.isTouch = PropertiesUtil.toBoolean((Object)config.get(TOUCH_UI), (boolean)true);
        this.wcmEditorTouchUrl = PropertiesUtil.toString((Object)config.get(WCM_EDITOR_URL_TOUCH), (String)WCM_EDITOR_URL_TOUCH_DEFAULT);
        this.wcmEditorClassicUrl = PropertiesUtil.toString((Object)config.get(WCM_EDITOR_URL_CLASSIC), (String)WCM_EDITOR_URL_CLASSIC_DEFAULT);
        this.damEditorTouchUrl = PropertiesUtil.toString((Object)config.get(DAM_EDITOR_URL_TOUCH), (String)DAM_EDITOR_URL_TOUCH_DEFAULT);
        this.damEditorClassicUrl = PropertiesUtil.toString((Object)config.get(DAM_EDITOR_URL_CLASSIC), (String)DAM_EDITOR_URL_CLASSIC_DEFAULT);
    }

    @Activate
    protected void activate(Map<String, String> config) {
        this.configure(config);
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }
}

