/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class PathInfoUtil {
    private PathInfoUtil() {
    }

    public static String getQueryParam(SlingHttpServletRequest request, String key) {
        return request.getParameter(key);
    }

    public static String getQueryParam(SlingHttpServletRequest request, String key, String dfault) {
        String tmp = request.getParameter(key);
        if (StringUtils.isBlank((CharSequence)tmp)) {
            return dfault;
        }
        return tmp;
    }

    public static String getSelector(SlingHttpServletRequest request, int index) {
        return PathInfoUtil.getSelector(request, index, null);
    }

    public static String getSelector(SlingHttpServletRequest request, int index, String defaultValue) {
        RequestPathInfo pathInfo = request.getRequestPathInfo();
        if (pathInfo == null) {
            return null;
        }
        String[] selectors = pathInfo.getSelectors();
        if (selectors == null) {
            return null;
        }
        if (index >= 0 && index < selectors.length) {
            return selectors[index];
        }
        return defaultValue;
    }

    public static String[] getSuffixSegments(SlingHttpServletRequest request) {
        RequestPathInfo pathInfo = request.getRequestPathInfo();
        if (pathInfo == null || pathInfo.getSuffix() == null) {
            return new String[0];
        }
        return StringUtils.split((String)pathInfo.getSuffix(), (char)'/');
    }

    public static String getSuffixSegment(SlingHttpServletRequest request, int index) {
        String[] suffixes = PathInfoUtil.getSuffixSegments(request);
        if (index >= 0 && index < suffixes.length) {
            return suffixes[index];
        }
        return null;
    }

    public static String getSuffix(SlingHttpServletRequest request) {
        RequestPathInfo pathInfo = request.getRequestPathInfo();
        if (pathInfo == null || pathInfo.getSuffix() == null) {
            return null;
        }
        return pathInfo.getSuffix();
    }

    public static String getFirstSuffixSegment(SlingHttpServletRequest request) {
        return PathInfoUtil.getSuffixSegment(request, 0);
    }

    public static String getLastSuffixSegment(SlingHttpServletRequest request) {
        String[] suffixes = PathInfoUtil.getSuffixSegments(request);
        if (suffixes.length < 1) {
            return null;
        }
        return suffixes[suffixes.length - 1];
    }
}

