/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.rewriter.impl;

import com.adobe.acs.commons.rewriter.impl.ContentHandlerAdapter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.sling.rewriter.Generator;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLParserGenerator
implements Generator {
    private final StringWriter writer;
    private final PrintWriter printWriter;
    private final SAXParser saxParser;
    private ContentHandler contentHandler;

    public XMLParserGenerator() throws ParserConfigurationException, SAXException {
        this(SAXParserFactory.newInstance());
    }

    public XMLParserGenerator(SAXParserFactory factory) throws ParserConfigurationException, SAXException {
        factory.setNamespaceAware(true);
        this.saxParser = factory.newSAXParser();
        this.saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        this.saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        this.writer = new StringWriter();
        this.printWriter = new PrintWriter(this.writer);
    }

    public void finished() throws IOException, SAXException {
        this.printWriter.flush();
        ContentHandlerAdapter handler = new ContentHandlerAdapter(this.contentHandler);
        String documentString = this.writer.toString();
        if (!documentString.isEmpty()) {
            InputSource source = new InputSource(new StringReader(documentString));
            this.saxParser.parse(source, (DefaultHandler)handler);
        }
    }

    public PrintWriter getWriter() {
        return this.printWriter;
    }

    public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void dispose() {
    }
}

