/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.form;

import com.adobe.acs.commons.mcp.form.AbstractResourceImpl;
import com.adobe.acs.commons.mcp.form.Description;
import com.adobe.acs.commons.mcp.form.FieldComponent;
import com.adobe.acs.commons.mcp.util.AccessibleObjectUtil;
import com.adobe.acs.commons.mcp.util.StringUtil;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public abstract class RadioComponent
extends FieldComponent {
    private static final String DESCRIPTION_DELIMITER = "::";

    @Override
    public void init() {
        this.setResourceType("granite/ui/components/foundation/form/radiogroup");
        this.getProperties().put("vertical", this.hasOption("vertical"));
        this.getProperties().put("text", this.getFieldDefinition().name());
        this.getProperties().remove("fieldLabel");
        this.getProperties().remove("fieldDescription");
    }

    @Override
    public Resource buildComponentResource() {
        AbstractResourceImpl component = (AbstractResourceImpl)super.buildComponentResource();
        AbstractResourceImpl options = new AbstractResourceImpl("items", null, null, new HashMap<String, Object>());
        component.addChild((Resource)options);
        String defaultValue = this.getOption("default").orElse(null);
        this.getOptions().forEach((value, name) -> {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            String nodeName = JcrUtil.escapeIllegalJcrChars((String)value);
            if (value.equals(defaultValue)) {
                properties.put("checked", true);
            }
            properties.put("name", this.getName());
            properties.put("value", value);
            if (name.contains(DESCRIPTION_DELIMITER)) {
                String description = StringUtils.substringAfter((String)name, (String)DESCRIPTION_DELIMITER);
                properties.put("title", description);
                name = StringUtils.substringBefore((String)name, (String)DESCRIPTION_DELIMITER);
            }
            properties.put("text", name);
            AbstractResourceImpl option = new AbstractResourceImpl("option_" + nodeName, "granite/ui/components/foundation/form/radio", "granite/ui/components/foundation/form/field", properties);
            options.addChild((Resource)option);
        });
        return component;
    }

    public abstract Map<String, String> getOptions();

    public static class EnumerationSelector
    extends RadioComponent {
        private static final Logger LOG = LoggerFactory.getLogger(EnumerationSelector.class);

        @Override
        public Map<String, String> getOptions() {
            return Stream.of((Enum[])AccessibleObjectUtil.getType(this.getAccessibleObject()).getEnumConstants()).collect(Collectors.toMap(Enum::name, this::getName, (k, v) -> {
                throw new IllegalArgumentException("cannot merge");
            }, LinkedHashMap::new));
        }

        private String getName(Enum e) {
            String name = StringUtil.getFriendlyName(e.name());
            try {
                Description desc = e.getClass().getField(e.name()).getAnnotation(Description.class);
                if (desc != null) {
                    name = name + RadioComponent.DESCRIPTION_DELIMITER + desc.value();
                }
            }
            catch (NoSuchFieldException | SecurityException ex) {
                LOG.error("Unable to lookup '{}' on class", (Object)name, (Object)ex);
            }
            return name;
        }
    }
}

