/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.form;

import com.adobe.acs.commons.mcp.form.AbstractResourceImpl;
import com.adobe.acs.commons.mcp.form.ContainerComponent;
import com.adobe.acs.commons.mcp.form.DialogProvider;
import com.adobe.acs.commons.mcp.form.FieldComponent;
import com.adobe.acs.commons.mcp.util.SyntheticResourceBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;

public abstract class AbstractGroupingContainerComponent
extends ContainerComponent {
    public static String GENERIC_GROUP = "Misc";
    public static final String MARGIN_PROPERTY = "margin";
    public static final String ITEMS = "items";
    private String layout = "";
    private boolean margin = true;
    private final Map<String, ContainerComponent> groups = new LinkedHashMap<String, ContainerComponent>();

    public ContainerComponent getOrCreateGroup(String groupName) {
        if (StringUtils.isBlank((CharSequence)groupName)) {
            String string = groupName = this.getPropertiesTabName() == null ? GENERIC_GROUP : this.getPropertiesTabName();
        }
        if (!this.groups.containsKey(groupName)) {
            ContainerComponent tab = new ContainerComponent();
            tab.setTitle(groupName);
            this.groups.put(groupName, tab);
            super.addComponent(groupName, tab);
            return tab;
        }
        return this.groups.get(groupName);
    }

    public void addComponent(String group, String fieldName, FieldComponent component) {
        this.getOrCreateGroup(group).addComponent(fieldName, component);
    }

    @Override
    public Resource buildComponentResource() {
        this.getProperties().put(MARGIN_PROPERTY, this.isMargin());
        AbstractResourceImpl res = (AbstractResourceImpl)super.buildComponentResource();
        AbstractResourceImpl layoutResource = new AbstractResourceImpl(res.getPath() + "/layout", this.getLayout(), null, null);
        res.addChild((Resource)layoutResource);
        return res;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public boolean isMargin() {
        return this.margin;
    }

    public void setMargin(boolean margin) {
        this.margin = margin;
    }

    public static class AccordionComponent
    extends AbstractGroupingContainerComponent {
        private String variant = "default";
        private boolean multiple = false;

        public AccordionComponent() {
            this.setLayout("granite/ui/components/coral/foundation/accordion");
        }

        @Override
        public Resource buildComponentResource() {
            this.getProperties().put("variant", this.getVariant());
            this.getProperties().put("multiple", this.isMultiple());
            return super.buildComponentResource();
        }

        public String getVariant() {
            return this.variant;
        }

        public void setVariant(String variant) {
            this.variant = variant;
        }

        public boolean isMultiple() {
            return this.multiple;
        }

        public void setMultiple(boolean multiple) {
            this.multiple = multiple;
        }
    }

    public static class TabsComponent
    extends AbstractGroupingContainerComponent {
        private String orientation = "horizontal";
        private String size = "M";

        public TabsComponent() {
            this.setLayout("granite/ui/components/foundation/layouts/tabs");
        }

        @Override
        public Resource buildComponentResource() {
            if (this.getDialogStyle() == DialogProvider.DialogStyle.COMPONENT) {
                this.setResourceType("granite/ui/components/coral/foundation/tabs");
                this.getProperties().put("maximized", true);
            }
            this.getProperties().put("orientation", this.getOrientation());
            this.getProperties().put("size", this.getSize());
            return super.buildComponentResource();
        }

        @Override
        protected AbstractResourceImpl generateItemsResource(String path, boolean useFieldSet) {
            AbstractResourceImpl items = super.generateItemsResource(path, useFieldSet);
            if (this.getDialogStyle() == DialogProvider.DialogStyle.COMPONENT) {
                SyntheticResourceBuilder rb = new SyntheticResourceBuilder(AbstractGroupingContainerComponent.ITEMS, null);
                items.children.forEach(tab -> {
                    rb.createChild(tab.getName(), tab.getResourceType()).withAttributes((Map<String, Object>)tab.getValueMap()).withAttributes(AbstractGroupingContainerComponent.MARGIN_PROPERTY, true);
                    rb.createChild(AbstractGroupingContainerComponent.ITEMS).createChild("columns", "granite/ui/components/coral/foundation/fixedcolumns").withAttributes(AbstractGroupingContainerComponent.MARGIN_PROPERTY, true).createChild(AbstractGroupingContainerComponent.ITEMS).createChild("column", "granite/ui/components/coral/foundation/container");
                    tab.getChildren().forEach(rb::withChild);
                    rb.up(5);
                });
                return rb.build();
            }
            return items;
        }

        public void setOrientation(String orientation) {
            this.orientation = orientation;
        }

        public String getSize() {
            return this.size;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public String getOrientation() {
            return this.orientation;
        }
    }
}

