/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.indesign.dynamicdeckdynamo.services.impl;

import com.adobe.acs.commons.indesign.dynamicdeckdynamo.exception.DynamicDeckDynamoException;
import com.adobe.acs.commons.indesign.dynamicdeckdynamo.services.DynamicDeckConfigurationService;
import com.adobe.acs.commons.indesign.dynamicdeckdynamo.services.DynamicDeckService;
import com.adobe.acs.commons.indesign.dynamicdeckdynamo.services.XMLGeneratorService;
import com.adobe.acs.commons.indesign.dynamicdeckdynamo.utils.DynamicDeckUtils;
import com.adobe.acs.commons.indesign.dynamicdeckdynamo.utils.XMLResourceIterator;
import com.adobe.dam.print.ids.PrintFormat;
import com.day.cq.commons.RangeIterator;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.tagging.TagManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DynamicDeckService.class})
public class DynamicDeckServiceImpl
implements DynamicDeckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicDeckServiceImpl.class);
    private static final PrintFormat[] formats = new PrintFormat[]{PrintFormat.JPG, PrintFormat.INDD, PrintFormat.PDF};
    private static final List<PrintFormat> allFormats = Arrays.asList(formats);
    @Reference
    private DynamicDeckConfigurationService configurationService;
    @Reference
    private XMLGeneratorService xmlGeneratorService;
    @Reference
    private JobManager jobManager;

    @Override
    public String createDeck(String deckName, Resource masterAssetResource, List<Resource> assetResourceList, Resource templateFolderResource, Resource destinationFolderResource, ResourceResolver resourceResolver) throws DynamicDeckDynamoException {
        String processedXmlPath;
        Resource inddTemplateResource = DynamicDeckUtils.findFileUnderFolderByExtension(templateFolderResource, "indd");
        Resource annotatedXmlResource = DynamicDeckUtils.findFileUnderFolderByExtension(templateFolderResource, "xml");
        if (null == inddTemplateResource || null == annotatedXmlResource) {
            throw new DynamicDeckDynamoException("Supplied INDD template folder path doesn't contain InDesign Template file OR template XML file : " + templateFolderResource.getPath());
        }
        StringBuilder idspScriptArgs = new StringBuilder();
        ArrayList<String> inddImageList = new ArrayList<String>();
        Asset damAsset = DynamicDeckUtils.createUniqueAsset(destinationFolderResource, JcrUtil.createValidName((String)deckName) + ".indd", resourceResolver);
        if (damAsset == null) {
            throw new DynamicDeckDynamoException("Dynamic Deck document not created at the destination : " + destinationFolderResource.getPath());
        }
        ArrayList<XMLResourceIterator> assetItrList = new ArrayList<XMLResourceIterator>();
        assetItrList.add(new XMLResourceIterator("generic", assetResourceList.listIterator()));
        try (InputStream templateXmlInputStream = DynamicDeckUtils.getAssetOriginalInputStream(annotatedXmlResource);){
            processedXmlPath = this.xmlGeneratorService.generateInddXML(templateXmlInputStream, assetItrList, masterAssetResource, (Resource)damAsset.adaptTo(Resource.class), resourceResolver, inddImageList);
        }
        catch (IOException e) {
            throw new DynamicDeckDynamoException(" Error while processing InDesign Template XML, hence exiting the deck generation process");
        }
        if (StringUtils.isBlank((CharSequence)processedXmlPath)) {
            throw new DynamicDeckDynamoException("Processed XML is null/empty, hence exiting the deck generation process");
        }
        StringBuilder exportFormats = DynamicDeckUtils.addExportFormat(damAsset, allFormats);
        StringBuilder imagePaths = DynamicDeckUtils.getImagePaths(inddImageList, this.configurationService.getPlaceholderImagePath());
        this.addIdsScriptArgs(inddTemplateResource.getPath(), (Resource)damAsset.adaptTo(Resource.class), idspScriptArgs, imagePaths, processedXmlPath, exportFormats);
        DynamicDeckUtils.commit(resourceResolver);
        return damAsset.getPath();
    }

    @Override
    public List<Resource> fetchAssetListFromCollection(Resource collectionResource, ResourceResolver resourceResolver) throws DynamicDeckDynamoException {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        if (DamUtil.isSmartCollection((Resource)collectionResource)) {
            return DynamicDeckUtils.fetchSmartCollectionResourceList(collectionResource);
        }
        Iterator assets = DamUtil.getAssets((Resource)collectionResource);
        assets.forEachRemaining(eachAsset -> {
            Resource eachAssetResource = (Resource)eachAsset.adaptTo(Resource.class);
            if (null != eachAssetResource) {
                arrayList.add((Resource)eachAsset.adaptTo(Resource.class));
            }
        });
        return arrayList;
    }

    @Override
    public List<Resource> fetchAssetListFromQuery(String queryString, ResourceResolver resourceResolver) {
        Iterator assetResourceIterator = resourceResolver.findResources(queryString, "JCR-SQL2");
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(assetResourceIterator, 16), false).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public List<Resource> fetchAssetListFromTags(String tagsString, ResourceResolver resourceResolver) {
        TagManager tagManager = (TagManager)resourceResolver.adaptTo(TagManager.class);
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        String[] tagsArray = StringUtils.split((String)tagsString, (String)",");
        Arrays.stream(tagsArray).forEach(tag -> {
            RangeIterator tags = tagManager.find(tag);
            tags.forEachRemaining(taggedResource -> {
                Asset taggedAsset;
                if (taggedResource.getPath().startsWith("/content/dam/") && taggedResource.getPath().endsWith("/jcr:content/metadata") && null != (taggedAsset = (Asset)taggedResource.getParent().getParent().adaptTo(Asset.class))) {
                    arrayList.add((Resource)taggedAsset.adaptTo(Resource.class));
                }
            });
        });
        return arrayList;
    }

    private void addExportJobProperty(Asset assetObject, String exportJobId) {
        if (assetObject == null) {
            LOGGER.error("Asset is null, hence export properties cannot be added.");
            return;
        }
        if (StringUtils.isBlank((CharSequence)exportJobId)) {
            LOGGER.error("ExportJobId is null/empty, hence export properties cannot be added.");
            return;
        }
        Resource assetResource = (Resource)assetObject.adaptTo(Resource.class);
        if (assetResource == null || ResourceUtil.isNonExistingResource((Resource)assetResource)) {
            LOGGER.error("Asset resource is null or doesn't exist, hence export properties cannot be added. {}", (Object)assetObject.getPath());
            return;
        }
        Resource content = assetResource.getChild("jcr:content");
        if (content == null || ResourceUtil.isNonExistingResource((Resource)content) && content.adaptTo(ModifiableValueMap.class) == null) {
            LOGGER.error("Asset JCR content is null or doesn't exist, hence export properties cannot be added. {}", (Object)assetResource.getPath());
            return;
        }
        ModifiableValueMap contentProperties = (ModifiableValueMap)content.adaptTo(ModifiableValueMap.class);
        if (contentProperties == null) {
            LOGGER.error("Property object is null, hence export properties cannot be added {}", (Object)assetResource.getPath());
            return;
        }
        contentProperties.put((Object)"exportJobId", (Object)exportJobId);
        contentProperties.put((Object)"dam:assetState", (Object)"processing");
        contentProperties.put((Object)"dam:templateType", (Object)"DYNAMIC DECK");
    }

    private Job addJob(Asset master, Map<String, Object> props) throws DynamicDeckDynamoException {
        Job offloadingJob = this.jobManager.addJob("dam/proxy/ids/job", props);
        if (offloadingJob == null) {
            throw new DynamicDeckDynamoException("Job manager is not able to create job");
        }
        this.addExportJobProperty(master, offloadingJob.getId());
        return offloadingJob;
    }

    private void addIdsScriptArgs(String templatePath, Resource masterAssetResource, StringBuilder idspScriptArgs, StringBuilder imagePaths, String formattedXMLPath, StringBuilder exportFormats) throws DynamicDeckDynamoException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        String[] scriptPaths = new String[]{"dam/indesign/scripts/json2.jsx/jcr:content", "dam/indesign/scripts/cq-lib.jsx/jcr:content", "dam/indesign/scripts/dynamic-deck.jsx/jcr:content"};
        idspScriptArgs.append(DynamicDeckUtils.createIDSPScriptArg("asset_name", masterAssetResource.getName()));
        idspScriptArgs.append(DynamicDeckUtils.createIDSPScriptArg("idTemplatePath", templatePath));
        idspScriptArgs.append(DynamicDeckUtils.createIDSPScriptArg("tagXmlPath", formattedXMLPath));
        idspScriptArgs.append(DynamicDeckUtils.createIDSPScriptArg("imageList", imagePaths.toString()));
        idspScriptArgs.append(DynamicDeckUtils.createIDSPScriptArg("formats", exportFormats.toString()));
        idspScriptArgs.append(DynamicDeckUtils.createIDSPScriptArg("type", "DYNAMIC DECK"));
        this.addIDSProperties(masterAssetResource.getPath(), idspScriptArgs, props, scriptPaths);
        this.addJob((Asset)masterAssetResource.adaptTo(Asset.class), props);
    }

    private void addIDSProperties(String assetPath, StringBuilder idspScriptArgs, Map<String, Object> props, String[] scriptPaths) {
        props.put("ids.job.script", scriptPaths);
        props.put("ids.job.payload", assetPath);
        props.put("offloading.input.payload", assetPath);
        props.put("offloading.output.payload", assetPath);
        props.put("idsprint.addtlSoapArgs", idspScriptArgs.toString());
    }
}

