/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.indesign.dynamicdeckdynamo.models;

import com.adobe.acs.commons.genericlists.GenericList;
import com.adobe.acs.commons.mcp.form.SelectComponent;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericListSelectComponent
extends SelectComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericListSelectComponent.class);
    public static final String GENERIC_LIST_PATH = "genericListPath";

    @Override
    public Map<String, String> getOptions() {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        if (null != this.getHelper() && null != this.getHelper().getRequest() && null != this.getHelper().getRequest().getResourceResolver()) {
            ResourceResolver resourceResolver = this.getHelper().getRequest().getResourceResolver();
            PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
            if (pageManager == null) {
                LOGGER.debug("Page manager is null, hence exiting the process and returning empty map");
                return Collections.emptyMap();
            }
            if (!this.hasOption(GENERIC_LIST_PATH)) {
                LOGGER.debug("Generic list path is null, hence exiting the process and returning empty map");
                return Collections.emptyMap();
            }
            Optional<String> listPath = this.getOption(GENERIC_LIST_PATH);
            if (!listPath.isPresent()) {
                LOGGER.debug("Generic list path under getOption is null, hence exiting the select options process and returning empty map");
                return Collections.emptyMap();
            }
            Page genericListPage = pageManager.getPage(listPath.get());
            if (genericListPage == null) {
                LOGGER.debug("Generic List Page is null, hence exiting the select options process and returning empty map");
                return Collections.emptyMap();
            }
            GenericList itemList = (GenericList)genericListPage.adaptTo(GenericList.class);
            if (itemList == null) {
                return Collections.emptyMap();
            }
            options.put("", "Select the Option");
            itemList.getItems().forEach(item -> options.put(item.getValue(), item.getTitle()));
        } else {
            LOGGER.error("Resource resolver is null while getting the generic list");
        }
        return options;
    }
}

