/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam.impl;

import com.adobe.acs.commons.dam.AbstractRenditionModifyingProcess;
import com.adobe.acs.commons.util.RequireAem;
import com.adobe.acs.commons.util.WorkflowHelper;
import com.day.cq.dam.api.Rendition;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.image.Layer;
import java.awt.Color;
import java.awt.Paint;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Matte Rendition"})
public final class MatteRenditionProcess
extends AbstractRenditionModifyingProcess
implements WorkflowProcess {
    private static final int RADIX_HEX = 16;
    private static final int COLOR_STRING_LENGTH = 6;
    private static final int DEFAULT_WIDTH = 1000;
    private static final int DEFAULT_HEIGHT = 1000;
    private static final Logger log = LoggerFactory.getLogger(MatteRenditionProcess.class);
    private static final String SPECIFIER = "matte";
    @Reference(target="(distribution=classic)")
    RequireAem requireAem;
    @Reference
    private WorkflowHelper workflowHelper;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        this.execute(workItem, workflowSession, metaDataMap, this.workflowHelper);
    }

    @Override
    protected String getTempFileSpecifier() {
        return SPECIFIER;
    }

    @Override
    protected Layer processLayer(Layer layer, Rendition rendition, WorkflowSession workflowSession, String[] args) {
        String horizontalPositionArgument;
        String dimensions = this.workflowHelper.getValuesFromArgs("dimension", args).size() > 0 ? this.workflowHelper.getValuesFromArgs("dimension", args).get(0) : null;
        String backgroundColor = this.workflowHelper.getValuesFromArgs("bgcolor", args).size() > 0 ? this.workflowHelper.getValuesFromArgs("bgcolor", args).get(0) : null;
        String verticalPositionArgument = this.workflowHelper.getValuesFromArgs("vpos", args).size() > 0 ? this.workflowHelper.getValuesFromArgs("vpos", args).get(0) : null;
        String string = horizontalPositionArgument = this.workflowHelper.getValuesFromArgs("hpos", args).size() > 0 ? this.workflowHelper.getValuesFromArgs("hpos", args).get(0) : null;
        if (dimensions != null && backgroundColor != null) {
            int leftAnchor;
            int topAnchor;
            int width = this.getDimension(dimensions)[0];
            int height = this.getDimension(dimensions)[1];
            if (layer.getHeight() == height && layer.getWidth() == width) {
                return layer;
            }
            Color matteColor = this.parseColor(backgroundColor, Color.BLACK);
            Layer newLayer = new Layer(width, height, (Paint)matteColor);
            newLayer.setMimeType(rendition.getMimeType());
            VerticalPosition vpos = VerticalPosition.valueOf(verticalPositionArgument);
            switch (vpos) {
                case bottom: {
                    topAnchor = newLayer.getHeight() - layer.getHeight();
                    break;
                }
                case middle: {
                    topAnchor = (newLayer.getHeight() - layer.getHeight()) / 2;
                    break;
                }
                default: {
                    topAnchor = 0;
                }
            }
            HoritzonalPosition hpos = HoritzonalPosition.valueOf(horizontalPositionArgument);
            switch (hpos) {
                case right: {
                    leftAnchor = newLayer.getWidth() - layer.getWidth();
                    break;
                }
                case center: {
                    leftAnchor = (newLayer.getWidth() - layer.getWidth()) / 2;
                    break;
                }
                default: {
                    leftAnchor = 0;
                }
            }
            newLayer.blit(layer, leftAnchor, topAnchor, layer.getWidth(), layer.getHeight(), 0, 0);
            return newLayer;
        }
        log.info("No dimension or background color specified. Skipping");
        return layer;
    }

    private Color parseColor(String str, Color defaultColor) {
        if ("transparent".equals(str)) {
            return null;
        }
        if (str == null || str.length() != 6) {
            return defaultColor;
        }
        int r = Integer.parseInt(str.substring(0, 2), 16);
        int g = Integer.parseInt(str.substring(2, 4), 16);
        int b = Integer.parseInt(str.substring(4, 6), 16);
        return new Color(r, g, b);
    }

    private Integer[] getDimension(String dimensions) {
        if (dimensions != null) {
            String[] splits = dimensions.split(":");
            Integer[] d = new Integer[]{Integer.valueOf(splits[0]), Integer.valueOf(splits[1])};
            return d;
        }
        return new Integer[]{1000, 1000};
    }

    protected void bindRequireAem(RequireAem requireAem) {
        this.requireAem = requireAem;
    }

    protected void unbindRequireAem(RequireAem requireAem) {
        if (this.requireAem == requireAem) {
            this.requireAem = null;
        }
    }

    protected void bindWorkflowHelper(WorkflowHelper workflowHelper) {
        this.workflowHelper = workflowHelper;
    }

    protected void unbindWorkflowHelper(WorkflowHelper workflowHelper) {
        if (this.workflowHelper == workflowHelper) {
            this.workflowHelper = null;
        }
    }

    static enum VerticalPosition {
        top,
        bottom,
        middle;

    }

    static enum HoritzonalPosition {
        left,
        right,
        center;

    }
}

