/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentsync;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentReader {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String BINARY_DATA_PLACEHOLDER = "0";
    private final NodeTypeManager nodeTypeManager;
    private final Collection<String> knownPropertyPrefixes;

    public ContentReader(Session session) throws RepositoryException {
        Workspace workspace = session.getWorkspace();
        this.knownPropertyPrefixes = new HashSet<String>(Arrays.asList(workspace.getNamespaceRegistry().getPrefixes()));
        this.nodeTypeManager = workspace.getNodeTypeManager();
    }

    public JsonObject sanitize(JsonObject node) throws RepositoryException {
        JsonObjectBuilder out = Json.createObjectBuilder();
        this.sanitize(node, out);
        return out.build();
    }

    private void sanitize(JsonObject node, JsonObjectBuilder out) throws RepositoryException {
        List<String> sanitizedProperties = this.getProtectedProperties(node);
        block4: for (Map.Entry field : node.entrySet()) {
            String prefix;
            String name = (String)field.getKey();
            int colonIdx = name.indexOf(58);
            if (colonIdx > 0 && !this.knownPropertyPrefixes.contains(prefix = name.substring(0, colonIdx))) {
                log.trace("skipping protected property: {}", (Object)name);
                continue;
            }
            if (sanitizedProperties.contains(name)) {
                log.trace("skipping unknown namespace: {}", (Object)name);
                continue;
            }
            JsonValue value = (JsonValue)field.getValue();
            switch (value.getValueType()) {
                case OBJECT: {
                    JsonObjectBuilder obj = Json.createObjectBuilder();
                    this.sanitize((JsonObject)value, obj);
                    out.add(name, obj);
                    continue block4;
                }
                case ARRAY: {
                    JsonArray array = (JsonArray)value;
                    out.add(name, (JsonValue)array);
                    continue block4;
                }
            }
            if (colonIdx == 0) {
                out.add(name.substring(1), BINARY_DATA_PLACEHOLDER);
                continue;
            }
            out.add(name, value);
        }
    }

    public List<String> getProtectedProperties(JsonObject node) throws RepositoryException {
        HashSet<String> ignored = new HashSet<String>(Arrays.asList("jcr:primaryType", "jcr:mixinTypes"));
        ArrayList<String> props = new ArrayList<String>();
        props.add("rep:policy");
        ArrayList<String> checkTypes = new ArrayList<String>();
        String primaryType = node.getString("jcr:primaryType");
        checkTypes.add(primaryType);
        JsonArray mixins = node.getJsonArray("jcr:mixinTypes");
        if (mixins != null) {
            for (JsonValue item : mixins) {
                checkTypes.add(((JsonString)item).getString());
            }
        }
        for (String typeName : checkTypes) {
            NodeType nodeType = this.nodeTypeManager.getNodeType(typeName);
            for (PropertyDefinition definition : nodeType.getPropertyDefinitions()) {
                if (!definition.isProtected() || ignored.contains(definition.getName())) continue;
                props.add(definition.getName());
            }
        }
        return props;
    }

    private void collectBinaryProperties(JsonObject node, String parent, List<String> binaryProperties) {
        for (Map.Entry field : node.entrySet()) {
            String name = (String)field.getKey();
            JsonValue value = (JsonValue)field.getValue();
            switch (value.getValueType()) {
                case OBJECT: {
                    this.collectBinaryProperties((JsonObject)value, parent + "/" + name, binaryProperties);
                    break;
                }
                case NUMBER: {
                    if (!name.startsWith(":")) break;
                    String propPath = parent + "/" + name.substring(1);
                    binaryProperties.add(propPath);
                    break;
                }
            }
        }
    }

    public List<String> collectBinaryProperties(JsonObject node) {
        ArrayList<String> binaryProperties = new ArrayList<String>();
        this.collectBinaryProperties(node, "", binaryProperties);
        return binaryProperties;
    }
}

