/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.ccvar.impl;

import com.adobe.acs.commons.ccvar.ContentVariableProvider;
import com.adobe.acs.commons.ccvar.PropertyAggregatorService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PropertyAggregatorService.class}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class PropertyAggregatorServiceImpl
implements PropertyAggregatorService {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyAggregatorServiceImpl.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)
    private List<ContentVariableProvider> variableProviders;

    @Override
    public Map<String, Object> getProperties(SlingHttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ContentVariableProvider variableProvider : this.variableProviders) {
            int sizeBefore = map.size();
            if (variableProvider.accepts(request)) {
                variableProvider.addProperties(map, request);
            } else {
                LOG.debug(variableProvider.getClass().getName() + " does not accept request for request at {}.", (Object)request.getPathInfo());
            }
            if (map.size() != sizeBefore) continue;
            LOG.debug(variableProvider.getClass().getName() + " either did not add any properties or replaced existing ones.");
        }
        return map;
    }
}

