/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.model;

import com.adobe.acs.commons.workflow.bulk.execution.model.PayloadGroup;
import com.adobe.acs.commons.workflow.bulk.execution.model.Status;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.Workflow;
import com.google.gson.JsonObject;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class Payload {
    private static final Logger log = LoggerFactory.getLogger(Payload.class);
    private static final String PN_WORKFLOW_INSTANCE_ID = "workflowInstanceId";
    private static final String PN_STATUS = "status";
    private static final String PN_PATH = "path";
    public static final String NN_PAYLOAD = "payload";
    private ModifiableValueMap properties;
    private Resource resource;
    @Inject
    private WorkflowService workflowService;
    @Inject
    @Default(values={"NOT_STARTED"})
    private String status;
    @Inject
    private String path;
    @Inject
    @Optional
    private String workflowInstanceId;

    public Payload(Resource resource) {
        this.resource = resource;
    }

    @PostConstruct
    public void activate() {
        this.properties = (ModifiableValueMap)this.resource.adaptTo(ModifiableValueMap.class);
    }

    public ResourceResolver getResourceResolver() {
        return this.resource.getResourceResolver();
    }

    public Status getStatus() {
        return (Status)EnumUtils.getEnum(Status.class, (String)this.status);
    }

    public String getPayloadPath() {
        return Payload.reference(this.path);
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public String getDereferencedPayloadPath() {
        return this.path;
    }

    public String getDereferencedPath() {
        return Payload.dereference(this.resource.getPath());
    }

    public PayloadGroup getPayloadGroup() {
        return (PayloadGroup)this.resource.getParent().adaptTo(PayloadGroup.class);
    }

    public Workflow getWorkflow() throws WorkflowException {
        WorkflowSession workflowSession = this.workflowService.getWorkflowSession((Session)this.resource.getResourceResolver().adaptTo(Session.class));
        String tmp = this.getWorkflowInstanceId();
        try {
            if (this.resource.getResourceResolver().getResource(tmp) != null) {
                return workflowSession.getWorkflow(tmp);
            }
        }
        catch (Exception e) {
            log.error(String.format("Could not get workflow with id [ %s ] for payload [ %s ~> %s ]", tmp, this.getPath(), this.getPayloadPath()), (Throwable)e);
        }
        return null;
    }

    public String getWorkflowInstanceId() {
        if (StringUtils.isBlank((String)this.workflowInstanceId)) {
            this.resource.getResourceResolver().refresh();
            this.workflowInstanceId = (String)this.properties.get(PN_WORKFLOW_INSTANCE_ID, String.class);
        }
        return Payload.reference(this.workflowInstanceId);
    }

    public boolean isOnboarded() {
        Status tmpStatus = this.getStatus();
        return tmpStatus != null && !Status.NOT_STARTED.equals((Object)tmpStatus);
    }

    public void setStatus(Status newStatus) {
        this.status = newStatus.toString();
        this.properties.put((Object)PN_STATUS, (Object)this.status);
    }

    public void updateWith(Workflow workflow) throws PersistenceException {
        if (StringUtils.isBlank((String)this.getWorkflowInstanceId())) {
            this.workflowInstanceId = workflow.getId();
            this.properties.put((Object)PN_WORKFLOW_INSTANCE_ID, (Object)Payload.dereference(this.workflowInstanceId));
        } else if (!StringUtils.equals((String)this.getWorkflowInstanceId(), (String)workflow.getId())) {
            throw new PersistenceException("Batch Entry workflow instance does not match. [ " + this.workflowInstanceId + " ] vs [ " + workflow.getId() + " ]");
        }
        if (!StringUtils.equals((String)this.status, (String)workflow.getState())) {
            this.setStatus((Status)EnumUtils.getEnum(Status.class, (String)workflow.getState()));
        }
    }

    public JsonObject toJSON() {
        JsonObject json = new JsonObject();
        json.addProperty(PN_STATUS, this.getStatus().toString());
        json.addProperty(PN_PATH, this.getPayloadPath());
        return json;
    }

    public static String dereference(String str) {
        if (!StringUtils.startsWith((String)str, (String)"-")) {
            str = "-" + str;
        }
        return str;
    }

    public static String reference(String str) {
        return StringUtils.removeStart((String)str, (String)"-");
    }
}

