/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.impl.servlets;

import com.adobe.acs.commons.workflow.bulk.execution.impl.TransientWorkflowUtil;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.AEMWorkflowRunnerImpl;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.FastActionManagerRunnerImpl;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.SyntheticWorkflowRunnerImpl;
import com.adobe.acs.commons.workflow.bulk.execution.impl.servlets.JSONErrorUtil;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.model.WorkflowModel;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"GET"}, resourceTypes={"acs-commons/components/utilities/bulk-workflow-manager"}, selectors={"init-form"}, extensions={"json"})
public class InitFormServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(InitFormServlet.class);
    private static final String KEY_RUNNER_TYPES = "runnerTypes";
    private static final String KEY_LABEL = "label";
    private static final String KEY_QUERY_TYPES = "queryTypes";
    private static final String KEY_VALUE = "value";
    private static final String KEY_USER_EVENT_DATA = "userEventData";
    @Reference
    private transient WorkflowService workflowService;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        JsonObject json = new JsonObject();
        this.accumulate(json, KEY_RUNNER_TYPES, (JsonElement)this.withLabelValue("AEM Workflow", AEMWorkflowRunnerImpl.class.getName()));
        this.accumulate(json, KEY_RUNNER_TYPES, (JsonElement)this.withLabelValue("Synthetic Workflow (Single-threaded)", SyntheticWorkflowRunnerImpl.class.getName()));
        this.accumulate(json, KEY_RUNNER_TYPES, (JsonElement)this.withLabelValue("Synthetic Workflow (Multi-threaded)", FastActionManagerRunnerImpl.class.getName()));
        this.accumulate(json, KEY_QUERY_TYPES, (JsonElement)this.withLabelValue("QueryBuilder", "queryBuilder"));
        this.accumulate(json, KEY_QUERY_TYPES, (JsonElement)this.withLabelValue("List", "list"));
        this.accumulate(json, KEY_QUERY_TYPES, (JsonElement)this.withLabelValue("xPath", "xpath"));
        this.accumulate(json, KEY_QUERY_TYPES, (JsonElement)this.withLabelValue("JCR-SQL2", "JCR-SQL2"));
        this.accumulate(json, KEY_QUERY_TYPES, (JsonElement)this.withLabelValue("JCR-SQL", "JCR-SQL"));
        this.accumulate(json, KEY_USER_EVENT_DATA, (JsonElement)this.withLabelValue("Custom user-event-data", ""));
        this.accumulate(json, KEY_USER_EVENT_DATA, (JsonElement)this.withLabelValue("changedByWorkflowProcess", "changedByWorkflowProcess"));
        this.accumulate(json, KEY_USER_EVENT_DATA, (JsonElement)this.withLabelValue("acs-aem-commons.bulk-workflow-manager", "acs-aem-commons.bulk-workflow-manager"));
        WorkflowSession workflowSession = this.workflowService.getWorkflowSession((Session)request.getResourceResolver().adaptTo(Session.class));
        try {
            WorkflowModel[] workflowModels;
            for (WorkflowModel workflowModel : workflowModels = workflowSession.getModels()) {
                boolean transientWorkflow = TransientWorkflowUtil.isTransient(request.getResourceResolver(), workflowModel.getId());
                String workflowLabel = workflowModel.getTitle();
                if (transientWorkflow) {
                    workflowLabel = workflowLabel + " ( Transient )";
                }
                JsonObject jsonWorkflow = this.withLabelValue(workflowLabel, workflowModel.getId());
                jsonWorkflow.addProperty("transient", Boolean.valueOf(transientWorkflow));
                this.accumulate(json, "workflowModels", (JsonElement)jsonWorkflow);
            }
            response.getWriter().write(json.toString());
        }
        catch (WorkflowException e) {
            log.error("Could not create workflow model drop-down.", (Throwable)e);
            JSONErrorUtil.sendJSONError(response, 500, "Could not collect workflows", e.getMessage());
        }
    }

    private JsonObject withLabelValue(String label, String value) {
        JsonObject obj = new JsonObject();
        obj.addProperty(KEY_LABEL, label);
        obj.addProperty(KEY_VALUE, value);
        return obj;
    }

    private JsonObject accumulate(JsonObject obj, String key, JsonElement value) {
        if (obj.has(key)) {
            JsonElement existingValue = obj.get(key);
            if (existingValue instanceof JsonArray) {
                ((JsonArray)existingValue).add(value);
            } else {
                JsonArray array = new JsonArray();
                array.add(existingValue);
                obj.add(key, (JsonElement)array);
            }
        } else {
            JsonArray array = new JsonArray();
            array.add(value);
            obj.add(key, (JsonElement)array);
        }
        return obj;
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }
}

