/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.vanity.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class RequestPathInfoWrapper
implements InvocationHandler {
    private final RequestPathInfo requestPathInfo;
    private final Resource resource;
    private static final String SLING_STATUS = "sling:status";

    private RequestPathInfoWrapper(RequestPathInfo requestPathInfo, Resource resource) {
        this.requestPathInfo = requestPathInfo;
        this.resource = resource;
    }

    public static RequestPathInfoWrapper createRequestPathInfoWrapper(RequestPathInfo requestPathInfo, Resource resource) {
        return new RequestPathInfoWrapper(requestPathInfo, resource);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "getResourcePath": {
                return this.getResourcePath();
            }
            case "getExtension": {
                return this.getExtension();
            }
            case "getSelectorString": {
                return this.getSelectorString();
            }
            case "getSelectors": {
                return this.getSelectors();
            }
            case "getSuffix": {
                return this.getSuffix();
            }
            case "getSuffixResource": {
                return this.getSuffixResource();
            }
        }
        throw new UnsupportedOperationException("REQUESTPATHINFOWRAPPER >> NO IMPLEMENTATION FOR " + methodName);
    }

    public String getResourcePath() {
        return this.requestPathInfo.getResourcePath();
    }

    public String getExtension() {
        ValueMap properties = this.resource.getValueMap();
        if (properties != null) {
            if ((Integer)properties.get(SLING_STATUS, (Object)-1) < 0) {
                return this.requestPathInfo.getExtension();
            }
            return null;
        }
        return this.requestPathInfo.getExtension();
    }

    public String getSelectorString() {
        return this.requestPathInfo.getSelectorString();
    }

    public String[] getSelectors() {
        return this.requestPathInfo.getSelectors();
    }

    public String getSuffix() {
        return this.requestPathInfo.getSuffix();
    }

    public Resource getSuffixResource() {
        return this.requestPathInfo.getSuffixResource();
    }
}

