/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.properties.shared.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import javax.servlet.ServletRequest;

public final class SharedPropertiesRequestCache {
    private static final String REQUEST_ATTRIBUTE_NAME = SharedPropertiesRequestCache.class.getName();
    private final Map<String, Bindings> cache = new HashMap<String, Bindings>();

    private SharedPropertiesRequestCache() {
    }

    public Bindings getBindings(String propertiesPath, Consumer<Bindings> computeIfNotFound) {
        return this.cache.computeIfAbsent(propertiesPath, key -> {
            SimpleBindings bindings = new SimpleBindings();
            computeIfNotFound.accept(bindings);
            return bindings;
        });
    }

    public static SharedPropertiesRequestCache fromRequest(ServletRequest req) {
        SharedPropertiesRequestCache cache = (SharedPropertiesRequestCache)req.getAttribute(REQUEST_ATTRIBUTE_NAME);
        if (cache == null) {
            cache = new SharedPropertiesRequestCache();
            cache.toRequest(req);
        }
        return cache;
    }

    public SharedPropertiesRequestCache toRequest(ServletRequest req) {
        SharedPropertiesRequestCache prev = (SharedPropertiesRequestCache)req.getAttribute(REQUEST_ATTRIBUTE_NAME);
        req.setAttribute(REQUEST_ATTRIBUTE_NAME, (Object)this);
        return prev;
    }
}

