/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.components.impl;

import com.adobe.acs.commons.wcm.components.TwitterFeedModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={TwitterFeedModel.class}, resourceType={"acs-commons/components/content/twitter-feed"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class TwitterFeedModelImpl
implements TwitterFeedModel {
    @ValueMapValue
    private String username;
    @ValueMapValue
    @Default(intValues={0})
    private int limit;
    @ValueMapValue
    @Default(values={})
    private List<String> tweets;

    @PostConstruct
    protected void init() {
        if (this.tweets == null) {
            this.tweets = new ArrayList<String>();
        }
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public List<String> getTweets() {
        List<String> limitedTweets = new ArrayList<String>(this.tweets);
        if (this.getLimit() > 0 && this.getLimit() < this.tweets.size()) {
            limitedTweets = this.tweets.subList(0, this.getLimit());
        }
        return limitedTweets;
    }

    @Override
    public boolean isReady() {
        return StringUtils.isNotEmpty((CharSequence)this.getUsername()) && !this.getTweets().isEmpty();
    }
}

