/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.visitors;

import com.adobe.acs.commons.util.visitors.SimpleFilteringResourceVisitor;
import java.util.Arrays;
import java.util.Optional;
import org.apache.sling.api.resource.Resource;

public class TreeFilteringResourceVisitor
extends SimpleFilteringResourceVisitor {
    protected static final String[] TREE_TYPES = new String[]{"nt:folder", "sling:Folder", "sling:OrderedFolder"};
    private String[] treeTypes;

    public TreeFilteringResourceVisitor() {
        this(TREE_TYPES);
    }

    public TreeFilteringResourceVisitor(String ... treeTypes) {
        this.treeTypes = Optional.ofNullable(treeTypes).map(array -> Arrays.copyOf(array, ((String[])array).length)).orElse(new String[0]);
        this.setTraversalFilter(this::isFolder);
    }

    public final boolean isFolder(Resource res) {
        String type = res.getResourceType();
        for (String treeType : this.treeTypes) {
            if (!type.equalsIgnoreCase(treeType)) continue;
            return true;
        }
        return false;
    }
}

