/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import com.adobe.acs.commons.util.impl.ValueMapTypeConverter;
import com.day.cq.commons.inherit.InheritanceValueMap;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.ValueMap;

public class ReflectionUtil {
    private static final Pattern CASTED_VALUE = Pattern.compile("\\{(Long|Integer|String|Boolean|Float|Double)}(.+)");

    private ReflectionUtil() {
    }

    public static <T> T convertValueMapValue(ValueMap valueMap, String name, Type declaredType) {
        return (T)new ValueMapTypeConverter(valueMap, name, declaredType).getConvertedValue();
    }

    public static <T> T convertValueMapValue(InheritanceValueMap valueMap, String name, Type declaredType) {
        return (T)new ValueMapTypeConverter(valueMap, name, declaredType).getConvertedValue();
    }

    public static <T> T[] toArray(Collection<T> c, T[] a) {
        return c.size() > a.length ? c.toArray((Object[])Array.newInstance(a.getClass().getComponentType(), c.size())) : c.toArray(a);
    }

    public static <T> T[] toArray(Collection<T> c, Class klass) {
        return ReflectionUtil.toArray(c, (Object[])Array.newInstance(klass, c.size()));
    }

    public static <T> T[] toArray(Collection<T> c) {
        return ReflectionUtil.toArray(c, c.iterator().next().getClass());
    }

    public static boolean isArray(Type declaredType) {
        if (declaredType instanceof Class) {
            Class clazz = (Class)declaredType;
            return ReflectionUtil.isArray(clazz);
        }
        return false;
    }

    public static boolean isArray(Class<?> clazz) {
        return clazz.isArray();
    }

    public static boolean isCollectionType(Type declaredType) {
        if (declaredType instanceof Class) {
            Class clazz = (Class)declaredType;
            return ReflectionUtil.isCollectionType(clazz);
        }
        ParameterizedType parameterizedType = (ParameterizedType)declaredType;
        return ReflectionUtil.isCollectionType(parameterizedType.getRawType());
    }

    public static boolean isCollectionType(Class<?> collectionType) {
        return collectionType.equals(Collection.class);
    }

    public static boolean isSetType(Type declaredType) {
        if (declaredType instanceof Class) {
            Class clazz = (Class)declaredType;
            return ReflectionUtil.isSetType(clazz);
        }
        ParameterizedType parameterizedType = (ParameterizedType)declaredType;
        return ReflectionUtil.isSetType(parameterizedType.getRawType());
    }

    public static boolean isSetType(Class<?> collectionType) {
        return collectionType.equals(Set.class);
    }

    public static boolean isListType(Type declaredType) {
        if (declaredType instanceof Class) {
            Class clazz = (Class)declaredType;
            return ReflectionUtil.isListType(clazz);
        }
        ParameterizedType parameterizedType = (ParameterizedType)declaredType;
        return ReflectionUtil.isListType(parameterizedType.getRawType());
    }

    public static boolean isListType(Class<?> collectionType) {
        return collectionType.equals(List.class);
    }

    public static Class<?> getClassOrGenericParam(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return ReflectionUtil.getGenericParameter(parameterizedType, 0);
        }
        Class clazz = (Class)type;
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        return clazz;
    }

    public static boolean isAssignableFrom(Type assignableFromType, Class<?> clazz) {
        if (assignableFromType == null || clazz == null) {
            return false;
        }
        if (assignableFromType instanceof Class) {
            Class assignAbleFromClazz = (Class)assignableFromType;
            return assignAbleFromClazz.isAssignableFrom(clazz);
        }
        ParameterizedType parameterizedType = (ParameterizedType)assignableFromType;
        return ((Class)parameterizedType.getRawType()).isAssignableFrom(clazz);
    }

    public static boolean hasGenericParameter(Type type) {
        return ParameterizedType.class.isInstance(type);
    }

    public static Class<?> getGenericParameter(Type type) {
        return ReflectionUtil.getGenericParameter(type, 0);
    }

    public static Class<?> getGenericParameter(Type type, int index) {
        if (ReflectionUtil.isArray(type)) {
            return ((Class)type).getComponentType();
        }
        if (ReflectionUtil.hasGenericParameter(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getActualTypeArguments()[index];
        }
        return null;
    }

    public static Object castStringValue(String allowedValue) {
        Matcher matcher = CASTED_VALUE.matcher(allowedValue);
        boolean match = matcher.matches();
        if (match) {
            String type = matcher.group(1);
            String value = matcher.group(2);
            switch (type) {
                case "Long": {
                    return Long.valueOf(value);
                }
                case "Integer": {
                    return Integer.valueOf(value);
                }
                case "Float": {
                    return Float.valueOf(value);
                }
                case "Boolean": {
                    if (value.equalsIgnoreCase("true")) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                case "Double": {
                    return Double.valueOf(value);
                }
            }
            return allowedValue;
        }
        return allowedValue;
    }
}

