/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import com.adobe.acs.commons.util.impl.AbstractCacheMBean;
import com.adobe.acs.commons.util.impl.JcrCacheMBean;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public abstract class AbstractJCRCacheMBean<K, V>
extends AbstractCacheMBean<K, V>
implements JcrCacheMBean {
    private final AtomicLong totalLoadTime = new AtomicLong();
    private final AtomicLong loadCount = new AtomicLong();
    private final AtomicLong loadSuccessCount = new AtomicLong();
    private final AtomicLong loadExceptionCount = new AtomicLong();
    private final AtomicLong hitCount = new AtomicLong();
    private final AtomicLong missCount = new AtomicLong();
    private final AtomicLong requestCount = new AtomicLong();
    private final AtomicLong evictionCount = new AtomicLong();
    private final AtomicLong totalLookupTime = new AtomicLong();

    public <T> AbstractJCRCacheMBean(T implementation, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(implementation, mbeanInterface);
    }

    protected AbstractJCRCacheMBean(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        super(mbeanInterface);
    }

    @Override
    public TabularData getCacheStats() throws OpenDataException {
        CompositeType cacheEntryType = new CompositeType("Cache Stats", "Cache Stats", new String[]{"Stat", "Value"}, new String[]{"Stat", "Value"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType("Cache Stats", "Cache Stats", cacheEntryType, new String[]{"Stat"}));
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("Stat", "Request Count");
        row.put("Value", String.valueOf(this.requestCount.get()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Average Lookup Time");
        row.put("Value", String.valueOf(this.getAvgLookupTime()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Total Lookup Time");
        row.put("Value", String.valueOf(this.totalLookupTime.get()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Hit Count");
        row.put("Value", String.valueOf(this.hitCount.get()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Hit Rate");
        row.put("Value", String.valueOf(this.getHitRate()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Miss Count");
        row.put("Value", String.valueOf(this.missCount.get()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Miss Rate");
        row.put("Value", String.valueOf(this.getMissRate()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Eviction Count");
        row.put("Value", String.valueOf(this.evictionCount.get()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Count");
        row.put("Value", String.valueOf(this.loadCount.get()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Exception Count");
        row.put("Value", String.valueOf(this.loadExceptionCount.get()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Exception Rate");
        row.put("Value", String.valueOf(this.getLoadExceptionRate()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Success Count");
        row.put("Value", String.valueOf(this.loadSuccessCount.get()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Success Rate");
        row.put("Value", String.valueOf(this.getLoadSuccessRate()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Average Load Penalty");
        row.put("Value", String.valueOf(this.getAvgLoadPenalty()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Total Load Time");
        row.put("Value", String.valueOf(this.totalLoadTime.get()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        return tabularData;
    }

    @Override
    public void resetCacheStats() {
        this.totalLoadTime.getAndSet(0L);
        this.loadCount.getAndSet(0L);
        this.loadSuccessCount.getAndSet(0L);
        this.loadExceptionCount.getAndSet(0L);
        this.hitCount.getAndSet(0L);
        this.missCount.getAndSet(0L);
        this.requestCount.getAndSet(0L);
        this.evictionCount.getAndSet(0L);
        this.totalLookupTime.getAndSet(0L);
    }

    private long getAvgLoadPenalty() {
        return this.loadCount.get() > 0L ? this.totalLoadTime.get() / this.loadCount.get() : 0L;
    }

    private long getAvgLookupTime() {
        return this.requestCount.get() > 0L ? this.totalLookupTime.get() / this.requestCount.get() : 0L;
    }

    private long getLoadSuccessRate() {
        return this.loadCount.get() > 0L ? this.loadSuccessCount.get() / this.loadCount.get() * 100L : 0L;
    }

    private long getLoadExceptionRate() {
        return this.loadCount.get() > 0L ? this.loadExceptionCount.get() / this.loadCount.get() * 100L : 0L;
    }

    private long getMissRate() {
        return this.requestCount.get() > 0L ? this.missCount.get() / this.requestCount.get() * 100L : 0L;
    }

    private long getHitRate() {
        return this.hitCount.get() > 0L ? this.hitCount.get() / this.requestCount.get() * 100L : 0L;
    }

    protected final void incrementLoadCount() {
        this.loadCount.incrementAndGet();
    }

    protected final void incrementLoadSuccessCount() {
        this.loadSuccessCount.incrementAndGet();
    }

    protected final void incrementLoadExceptionCount() {
        this.loadExceptionCount.incrementAndGet();
    }

    protected final void incrementHitCount() {
        this.hitCount.incrementAndGet();
    }

    protected final void incrementMissCount() {
        this.missCount.incrementAndGet();
    }

    protected final void incrementRequestCount() {
        this.requestCount.incrementAndGet();
    }

    protected final void incrementEvictionCount(long delta) {
        this.evictionCount.addAndGet(delta);
    }

    protected final void incrementTotalLookupTime(long delta) {
        this.totalLookupTime.addAndGet(delta);
    }

    protected final void incrementTotalLoadTime(long delta) {
        this.totalLoadTime.addAndGet(delta);
    }
}

