/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util;

import com.adobe.acs.commons.util.BufferedServletResponse;
import com.adobe.acs.commons.util.ServletOutputStreamWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferedServletOutput {
    private static final Logger log = LoggerFactory.getLogger(BufferedServletResponse.class);
    private final ServletResponse wrappedResponse;
    private final StringWriter writer;
    private final PrintWriter printWriter;
    private final ByteArrayOutputStream outputStream;
    private final ServletOutputStream servletOutputStream;
    private boolean flushWrappedBuffer;
    private ResponseWriteMethod writeMethod;
    private boolean flushBufferOnClose = true;

    public BufferedServletOutput(ServletResponse wrappedResponse) {
        this(wrappedResponse, new StringWriter(), new ByteArrayOutputStream());
    }

    public BufferedServletOutput(ServletResponse wrappedResponse, StringWriter writer, ByteArrayOutputStream outputStream) {
        this.wrappedResponse = wrappedResponse;
        this.writer = writer;
        this.printWriter = writer != null ? new PrintWriter(writer) : null;
        this.outputStream = outputStream;
        this.servletOutputStream = outputStream != null ? new ServletOutputStreamWrapper(outputStream) : null;
    }

    ServletOutputStream getOutputStream() throws IOException {
        if (ResponseWriteMethod.WRITER.equals((Object)this.writeMethod)) {
            throw new IllegalStateException("Cannot invoke getOutputStream() once getWriter() has been called.");
        }
        this.writeMethod = ResponseWriteMethod.OUTPUTSTREAM;
        if (this.servletOutputStream != null) {
            return this.servletOutputStream;
        }
        return this.wrappedResponse.getOutputStream();
    }

    PrintWriter getWriter() throws IOException {
        if (ResponseWriteMethod.OUTPUTSTREAM.equals((Object)this.writeMethod)) {
            throw new IllegalStateException("Cannot invoke getWriter() once getOutputStream() has been called.");
        }
        this.writeMethod = ResponseWriteMethod.WRITER;
        if (this.printWriter != null) {
            return this.printWriter;
        }
        return this.wrappedResponse.getWriter();
    }

    public ResponseWriteMethod getWriteMethod() {
        return this.writeMethod;
    }

    public String getBufferedString() {
        if (ResponseWriteMethod.OUTPUTSTREAM.equals((Object)this.writeMethod)) {
            throw new IllegalStateException("Cannot invoke getBufferedString() once getOutputStream() has been called.");
        }
        if (this.writer == null) {
            throw new IllegalStateException("Cannot get buffered string, as the writer was not buffered!");
        }
        return this.writer.toString();
    }

    boolean hasPendingData() {
        if (ResponseWriteMethod.OUTPUTSTREAM.equals((Object)this.writeMethod)) {
            return false;
        }
        if (this.writer == null) {
            return false;
        }
        return this.writer.toString().length() > 0;
    }

    public byte[] getBufferedBytes() {
        if (ResponseWriteMethod.WRITER.equals((Object)this.writeMethod)) {
            throw new IllegalStateException("Cannot invoke getBufferedBytes() once getWriter() has been called.");
        }
        if (this.outputStream == null) {
            throw new IllegalStateException("Cannot get buffered bytes, as the output stream was not buffered!");
        }
        return this.outputStream.toByteArray();
    }

    public void resetBuffer() {
        if (this.writer != null) {
            this.writer.getBuffer().setLength(0);
        }
        if (this.outputStream != null) {
            this.outputStream.reset();
        }
        this.wrappedResponse.resetBuffer();
    }

    public void setFlushBufferOnClose(boolean flushBufferOnClose) {
        this.flushBufferOnClose = flushBufferOnClose;
    }

    void close() throws IOException {
        if (this.flushBufferOnClose) {
            if (ResponseWriteMethod.OUTPUTSTREAM.equals((Object)this.writeMethod) && this.outputStream != null && this.getBufferedBytes().length > 0) {
                this.wrappedResponse.getOutputStream().write(this.getBufferedBytes());
            } else if (ResponseWriteMethod.WRITER.equals((Object)this.writeMethod) && this.writer != null && this.getBufferedString().length() > 0) {
                this.wrappedResponse.getWriter().write(this.getBufferedString());
            }
        }
        if (this.flushWrappedBuffer) {
            this.wrappedResponse.flushBuffer();
        }
    }

    public void flushBuffer() throws IOException {
        if (this.isBuffered()) {
            log.debug("Prevent committing the response, it will be committed deferred, i.e. once this buffered response is closed");
            if (log.isDebugEnabled()) {
                Throwable t = new Throwable("");
                log.debug("Stacktrace which triggered ServletResponse.flushBuffer()", t);
            }
            this.flushWrappedBuffer = true;
        } else {
            this.wrappedResponse.flushBuffer();
        }
    }

    private boolean isBuffered() {
        return this.writeMethod == null || ResponseWriteMethod.OUTPUTSTREAM.equals((Object)this.writeMethod) && this.outputStream != null || ResponseWriteMethod.WRITER.equals((Object)this.writeMethod) && this.writer != null;
    }

    public static enum ResponseWriteMethod {
        OUTPUTSTREAM,
        WRITER;

    }
}

