/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.users.impl;

import com.adobe.acs.commons.users.impl.AbstractAuthorizable;
import com.adobe.acs.commons.users.impl.EnsureAce;
import com.adobe.acs.commons.users.impl.EnsureAuthorizable;
import com.adobe.acs.commons.users.impl.EnsureAuthorizableException;
import com.adobe.acs.commons.users.impl.Group;
import com.adobe.acs.commons.users.impl.Operation;
import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Ensure Group", configurationFactory=true, metatype=true, immediate=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="webconsole.configurationFactory.nameHint", value={"Ensure Group: {operation} {principalName}"})})
@Service(value={EnsureGroup.class, EnsureAuthorizable.class})
public final class EnsureGroup
implements EnsureAuthorizable {
    @Property(label="Ensure immediately", boolValue={true}, description="Ensure on activation. When set to false, this must be ensured via the JMX MBean.")
    public static final String PROP_ENSURE_IMMEDIATELY = "ensure-immediately";
    public static final String DEFAULT_OPERATION = "add";
    @Property(label="Operation", description="Defines if the group (principal name) should be adjusted to align with this config or removed completely", options={@PropertyOption(name="add", value="Ensure existence (add)"), @PropertyOption(name="remove", value="Ensure extinction (remove)")})
    public static final String PROP_OPERATION = "operation";
    @Property(label="Principal Name", description="The grouo's principal name")
    public static final String PROP_PRINCIPAL_NAME = "principalName";
    @Property(label="ACEs", description="This field is ignored if the Operation is set to 'Ensure extinction' (remove)", cardinality=0x7FFFFFFF)
    public static final String PROP_ACES = "aces";
    @Property(label="Member Of", description="Defines groups this group must be a member of.  Group will be removed from any groups not listed.", cardinality=0x7FFFFFFF)
    public static final String PROP_MEMBER_OF = "member-of";
    private static final Logger log = LoggerFactory.getLogger(EnsureGroup.class);
    private static final String SERVICE_NAME = "ensure-service-user";
    private static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "ensure-service-user");
    private static final boolean DEFAULT_ENSURE_IMMEDIATELY = true;
    private Group group = null;
    private Operation operation = null;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private EnsureAce ensureAce;

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public Group getAuthorizable() {
        return this.group;
    }

    @Override
    public void ensure(Operation operation, AbstractAuthorizable group) throws EnsureAuthorizableException {
        long start = System.currentTimeMillis();
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH_INFO);){
            if (Operation.ADD.equals((Object)operation)) {
                this.ensureExistance(resourceResolver, (Group)group);
            } else if (Operation.REMOVE.equals((Object)operation)) {
                this.ensureRemoval(resourceResolver, (Group)group);
            } else {
                throw new EnsureAuthorizableException("Unable to determine Ensure Group operation Could not create or locate value group (it is null).");
            }
            if (resourceResolver.hasChanges()) {
                resourceResolver.commit();
                log.debug("Persisted change to Group [ {} ]", (Object)group.getPrincipalName());
            } else {
                log.debug("No changes required for Group [ {} ]. Skipping...", (Object)group.getPrincipalName());
            }
            log.info("Successfully ensured [ {} ] of Group [ {} ] in [ {} ms ]", new Object[]{operation, this.getAuthorizable().getPrincipalName(), String.valueOf(System.currentTimeMillis() - start)});
        }
        catch (Exception e) {
            throw new EnsureAuthorizableException(String.format("Failed to ensure [ %s ] of Group [ %s ]", operation.toString(), group.getPrincipalName()), e);
        }
    }

    protected void ensureExistance(ResourceResolver resourceResolver, Group group) throws RepositoryException, EnsureAuthorizableException {
        org.apache.jackrabbit.api.security.user.Group jcrGroup = this.ensureGroup(resourceResolver, group);
        if (jcrGroup != null) {
            this.ensureAce.ensureAces(resourceResolver, (Authorizable)jcrGroup, group);
            this.ensureMembership(resourceResolver, jcrGroup, group);
        } else {
            log.error("Could not create or locate Group with principal name [ {} ]", (Object)group.getPrincipalName());
        }
    }

    private void ensureRemoval(ResourceResolver resourceResolver, Group group) throws RepositoryException, EnsureAuthorizableException {
        org.apache.jackrabbit.api.security.user.Group jcrGroup = this.findGroup(resourceResolver, group.getPrincipalName());
        this.ensureAce.removeAces(resourceResolver, (Authorizable)jcrGroup, group);
        if (jcrGroup != null) {
            this.ensureRemoveMembership(jcrGroup);
            jcrGroup.remove();
        }
    }

    private org.apache.jackrabbit.api.security.user.Group ensureGroup(ResourceResolver resourceResolver, Group group) throws RepositoryException, EnsureAuthorizableException {
        org.apache.jackrabbit.api.security.user.Group jcrGroup = this.findGroup(resourceResolver, group.getPrincipalName());
        if (jcrGroup == null) {
            UserManager userManager = (UserManager)resourceResolver.adaptTo(UserManager.class);
            log.debug("Requesting creation of group [ {} ] at [ {} ]", (Object)group.getPrincipalName(), (Object)group.getIntermediatePath());
            jcrGroup = userManager.createGroup((Principal)new SimplePrincipal(group.getPrincipalName()), group.getIntermediatePath());
            log.debug("Created group at [ {} ]", (Object)jcrGroup.getPath());
        }
        return jcrGroup;
    }

    private org.apache.jackrabbit.api.security.user.Group findGroup(ResourceResolver resourceResolver, String principalName) throws RepositoryException, EnsureAuthorizableException {
        UserManager userManager = (UserManager)resourceResolver.adaptTo(UserManager.class);
        org.apache.jackrabbit.api.security.user.Group jcrGroup = null;
        Authorizable authorizable = userManager.getAuthorizable(principalName);
        if (authorizable != null) {
            if (authorizable instanceof org.apache.jackrabbit.api.security.user.Group) {
                jcrGroup = (org.apache.jackrabbit.api.security.user.Group)authorizable;
            } else {
                throw new EnsureAuthorizableException(String.format("Authorizable [ %s ] at [ %s ] is not a group", principalName, authorizable.getPath()));
            }
        }
        return jcrGroup;
    }

    private void ensureMembership(ResourceResolver resourceResolver, org.apache.jackrabbit.api.security.user.Group jcrGroup, Group group) throws EnsureAuthorizableException, RepositoryException {
        UserManager userManager = (UserManager)resourceResolver.adaptTo(UserManager.class);
        List<String> memberOf = group.getMemberOf();
        Iterator groupIterator = jcrGroup.declaredMemberOf();
        while (groupIterator.hasNext()) {
            org.apache.jackrabbit.api.security.user.Group next = (org.apache.jackrabbit.api.security.user.Group)groupIterator.next();
            String groupName = next.getPrincipal().getName();
            if (!memberOf.contains(groupName)) {
                next.removeMember((Authorizable)jcrGroup);
                continue;
            }
            group.addMembership(groupName);
        }
        for (String groupName : group.getMissingMemberOf()) {
            Authorizable authorizable = userManager.getAuthorizable(groupName);
            if (authorizable == null) continue;
            if (authorizable instanceof org.apache.jackrabbit.api.security.user.Group) {
                org.apache.jackrabbit.api.security.user.Group groupToAdd = (org.apache.jackrabbit.api.security.user.Group)authorizable;
                groupToAdd.addMember((Authorizable)jcrGroup);
                continue;
            }
            throw new EnsureAuthorizableException(String.format("Authorizable [ %s ] at [ %s ] is not a group", groupName, authorizable.getPath()));
        }
    }

    private void ensureRemoveMembership(org.apache.jackrabbit.api.security.user.Group jcrGroup) throws RepositoryException {
        Iterator groupIterator = jcrGroup.declaredMemberOf();
        while (groupIterator.hasNext()) {
            org.apache.jackrabbit.api.security.user.Group next = (org.apache.jackrabbit.api.security.user.Group)groupIterator.next();
            next.removeMember((Authorizable)jcrGroup);
        }
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        boolean ensureImmediately = PropertiesUtil.toBoolean((Object)config.get(PROP_ENSURE_IMMEDIATELY), (boolean)true);
        String operationStr = StringUtils.upperCase((String)PropertiesUtil.toString((Object)config.get(PROP_OPERATION), (String)DEFAULT_OPERATION));
        try {
            this.operation = Operation.valueOf(operationStr);
            this.group = new Group(config);
            if (ensureImmediately) {
                this.ensure(this.operation, this.getAuthorizable());
            } else {
                log.info("This Group is configured to NOT ensure immediately. Please ensure this Group via the JMX MBean.");
            }
        }
        catch (EnsureAuthorizableException e) {
            log.error("Unable to ensure Group [ {} ]", (Object)PropertiesUtil.toString((Object)config.get(PROP_PRINCIPAL_NAME), (String)"Undefined Group Principal Name"), (Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown Ensure Group operation [ " + operationStr + " ]", e);
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindEnsureAce(EnsureAce ensureAce) {
        this.ensureAce = ensureAce;
    }

    protected void unbindEnsureAce(EnsureAce ensureAce) {
        if (this.ensureAce == ensureAce) {
            this.ensureAce = null;
        }
    }

    private static class SimplePrincipal
    implements Principal {
        protected final String name;

        public SimplePrincipal(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("Principal name cannot be blank.");
            }
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Principal) {
                return this.name.equals(((Principal)obj).getName());
            }
            return false;
        }
    }
}

