/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.users.impl;

import com.adobe.acs.commons.users.impl.EnsureAuthorizable;
import com.adobe.acs.commons.users.impl.EnsureAuthorizableException;
import com.adobe.acs.commons.users.impl.EnsureAuthorizableManager;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Properties(value={@Property(label="MBean Name", name="jmx.objectname", value={"com.adobe.acs.commons:type=Ensure Service User"})})
@References(value={@Reference(referenceInterface=EnsureAuthorizable.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE)})
@Service(value={DynamicMBean.class})
public class EnsureAuthorizableManagerImpl
extends AnnotatedStandardMBean
implements EnsureAuthorizableManager {
    private static final Logger log = LoggerFactory.getLogger(EnsureAuthorizableManagerImpl.class);
    private Map<String, EnsureAuthorizable> ensureAuthorizables = new ConcurrentHashMap<String, EnsureAuthorizable>();

    public EnsureAuthorizableManagerImpl() throws NotCompliantMBeanException {
        super(EnsureAuthorizableManager.class);
    }

    @Override
    public final void ensureAll() {
        for (EnsureAuthorizable ensureAuthorizable : this.ensureAuthorizables.values()) {
            try {
                ensureAuthorizable.ensure(ensureAuthorizable.getOperation(), ensureAuthorizable.getAuthorizable());
            }
            catch (EnsureAuthorizableException e) {
                log.error("Error Ensuring Authorizable [ {} ]", (Object)ensureAuthorizable.getAuthorizable().getPrincipalName(), (Object)e);
            }
        }
    }

    @Override
    public final void ensurePrincipalName(String principalName) {
        for (EnsureAuthorizable ensureAuthorizable : this.ensureAuthorizables.values()) {
            if (!StringUtils.equals((String)principalName, (String)ensureAuthorizable.getAuthorizable().getPrincipalName())) continue;
            try {
                ensureAuthorizable.ensure(ensureAuthorizable.getOperation(), ensureAuthorizable.getAuthorizable());
            }
            catch (EnsureAuthorizableException e) {
                log.error("Error Ensuring Authorizable [ {} ]", (Object)ensureAuthorizable.getAuthorizable().getPrincipalName(), (Object)e);
            }
        }
    }

    protected final void bindEnsureAuthorizable(EnsureAuthorizable service, Map<Object, Object> props) {
        String type = PropertiesUtil.toString((Object)props.get("service.pid"), null);
        if (type != null) {
            this.ensureAuthorizables.put(type, service);
        }
    }

    protected final void unbindEnsureAuthorizable(EnsureAuthorizable service, Map<Object, Object> props) {
        String type = PropertiesUtil.toString((Object)props.get("service.pid"), null);
        if (type != null) {
            this.ensureAuthorizables.remove(type);
        }
    }
}

