/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.internal;

import com.adobe.acs.commons.reports.api.ReportException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportExecutorProvider {
    public static final ReportExecutorProvider INSTANCE = new ReportExecutorProvider();
    private static final Logger log = LoggerFactory.getLogger(ReportExecutorProvider.class);

    private ReportExecutorProvider() {
    }

    public Class<?> getReportExecutor(DynamicClassLoaderManager dynamicClassLoaderManager, Resource config) throws ReportException {
        String reportExecutorClass = (String)config.getValueMap().get("reportExecutor", String.class);
        if (StringUtils.isBlank((String)reportExecutorClass)) {
            throw new ReportException("No executor configuration found for " + config);
        }
        try {
            log.debug("Loading class for: {}", (Object)reportExecutorClass);
            return Class.forName(reportExecutorClass, true, dynamicClassLoaderManager.getDynamicClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new ReportException("Unable to find class for " + reportExecutorClass, ex);
        }
    }
}

