/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.status.impl;

import com.adobe.acs.commons.packaging.PackageHelper;
import com.adobe.acs.commons.replication.status.ReplicationStatusManager;
import com.adobe.acs.commons.util.ClusterLeader;
import com.adobe.acs.commons.util.ParameterUtil;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Package Replication Status Updater", description="Event handler that listens for Jcr Package replications and updates the Replication Status of its content accordingly.", metatype=true, immediate=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(label="Event Topics", value={"com/day/cq/replication", "com/adobe/granite/replication"}, description="[Required] Event Topics this event handler will to respond to.", name="event.topics", propertyPrivate=true), @Property(label="Event Filters", value={"(type=ACTIVATE)"}, name="event.filter", propertyPrivate=true), @Property(name="job.topics", value={"acs-commons/replication/package"}, propertyPrivate=true)})
@Service
public class JcrPackageReplicationStatusEventHandler
implements JobConsumer,
EventHandler {
    private static final Logger log = LoggerFactory.getLogger(JcrPackageReplicationStatusEventHandler.class);
    private static final String FALLBACK_REPLICATION_USER_ID = "Package Replication";
    private static final String PROPERTY_PATHS = "paths";
    private static final String PROPERTY_PATH = "path";
    private static final String PROPERTY_REPLICATED_BY = "replicatedBy";
    private static final String PROPERTY_AGENT_IDS = "agentId";
    static final String[] DEFAULT_REPLICATION_STATUS_NODE_TYPES = new String[]{"cq:Page/cq:PageContent (?!/conf/.*/settings/wcm/templates/[^/]*/initial).*", "dam:AssetContent", "rep:User", "rep:Group", "sling:OrderedFolder/nt:unstructured", "cq:ReplicationStatus", "cq:Page/nt:unstructured /conf/.*/settings/wcm/templates/.*/policies/.*", "nt:unstructured /conf/.*/settings/wcm/policies/.*"};
    @Property(label="Replication Status Node Type and Path Restrictions", description="Node types that are candidates to update Replication Status on. Each item has the format '<nodetype-restriction> (<path-restriction>)'. The <path-restriction> is optional. The <nodetype-restriction> may be composed out of several node types separated by '/'. Make sure that one (composed)nodetype value appears only once in the list (because duplicate nodetypes will overwrite each other)! Also the order is important as the first nodetype hit (from the top of the list) determines the outcome.", cardinality=0x7FFFFFFF, value={"cq:Page/cq:PageContent (?!/conf/.*/settings/wcm/templates/[^/]*/initial).*", "dam:AssetContent", "rep:User", "rep:Group", "sling:OrderedFolder/nt:unstructured", "cq:ReplicationStatus", "cq:Page/nt:unstructured /conf/.*/settings/wcm/templates/.*/policies/.*", "nt:unstructured /conf/.*/settings/wcm/policies/.*"})
    public static final String PROP_REPLICATION_STATUS_NODE_TYPES = "node-types";
    private Map<String, Pattern> pathRestrictionByNodeType;
    protected static final String JOB_TOPIC = "acs-commons/replication/package";
    @Reference
    private Packaging packaging;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private ReplicationStatusManager replicationStatusManager;
    @Reference
    private PackageHelper packageHelper;
    @Reference
    private JobManager jobManager;
    @Reference
    private ClusterLeader clusterLeader;
    private static final String DEFAULT_REPLICATED_BY_OVERRIDE = "";
    private String replicatedByOverride = "";
    @Property(label="'Replicated By' Override", description="The 'user name' to set the 'replicated by' property to. If left blank the ACTUAL user that issued the package replication will be used. Defaults to blank.", value={""})
    public static final String PROP_REPLICATED_BY_OVERRIDE = "replicated-by.override";
    public static final String LEGACY_PROP_REPLICATED_BY_OVERRIDE = "replicated-by";
    private static final ReplicatedAt DEFAULT_REPLICATED_AT = ReplicatedAt.PACKAGE_LAST_MODIFIED;
    private ReplicatedAt replicatedAt = DEFAULT_REPLICATED_AT;
    @Property(label="Replicated At", description="The 'value' used to set the 'replicated at' property. [ Default: Package Last Modified ]", options={@PropertyOption(name="PACKAGE_LAST_MODIFIED", value="Package Last Modified"), @PropertyOption(name="CURRENT_TIME", value="Current Time")})
    public static final String PROP_REPLICATED_AT = "replicated-at";
    private static final String SERVICE_NAME = "package-replication-status-event-listener";
    private static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "package-replication-status-event-listener");

    public final void handleEvent(Event event) {
        Map<String, Object> jobConfig = this.getInfoFromEvent(event);
        String[] paths = (String[])jobConfig.get(PROPERTY_PATHS);
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH_INFO);){
            for (String path : paths) {
                JcrPackage jcrPackage;
                if (!this.containsJcrPackagePath(path) || (jcrPackage = this.getJcrPackage(resourceResolver, path)) == null) continue;
                jcrPackage.close();
                jobConfig.put(PROPERTY_PATH, path);
                this.jobManager.addJob(JOB_TOPIC, jobConfig);
            }
        }
        catch (LoginException e) {
            log.error("Could not obtain a resource resolver.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final JobConsumer.JobResult process(Job job) {
        String path = (String)job.getProperty(PROPERTY_PATH);
        String replicatedBy = StringUtils.defaultIfEmpty((String)this.replicatedByOverride, (String)((String)job.getProperty(PROPERTY_REPLICATED_BY)));
        Set<String> agentIds = (Set<String>)job.getProperty(PROPERTY_AGENT_IDS, List.class);
        if (agentIds == null) {
            agentIds = Collections.emptySet();
        }
        log.debug("Processing Replication Status Update for JCR Package: {}", (Object)path);
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH_INFO);){
            JcrPackage jcrPackage = this.getJcrPackage(resourceResolver, path);
            if (jcrPackage == null) {
                log.warn("JCR Package is unavailable for Replication Status Update at: {}", (Object)path);
                JobConsumer.JobResult jobResult = JobConsumer.JobResult.OK;
                return jobResult;
            }
            try {
                this.setReplicationStatus(jcrPackage, agentIds, replicatedBy, resourceResolver);
                return JobConsumer.JobResult.OK;
            }
            finally {
                jcrPackage.close();
            }
        }
        catch (LoginException e) {
            log.error("Could not obtain a resource resolver for applying replication status updates", (Throwable)e);
            return JobConsumer.JobResult.CANCEL;
        }
        catch (RepositoryException e) {
            this.logJobError(job, "Could not update replication metadata", (Exception)((Object)e));
            return JobConsumer.JobResult.FAILED;
        }
    }

    private void logJobError(Job job, String errorMessage, Exception e) {
        if (job.getRetryCount() < job.getNumberOfRetries()) {
            log.warn("Job failed with error '{}' in attempt '{}', retry later.", new Object[]{errorMessage, job.getRetryCount(), e});
        } else {
            log.error("Job permanently failed with error '{}' in attempt '{}', no more retries", new Object[]{errorMessage, job.getRetryCount(), e});
        }
    }

    private void setReplicationStatus(JcrPackage jcrPackage, Collection<String> agentIds, String replicatedBy, ResourceResolver resourceResolver) throws RepositoryException {
        String packageId;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try {
            JcrPackageDefinition packageDefinition = jcrPackage.getDefinition();
            if (packageDefinition == null) {
                throw new RepositoryException("Could not determine the ID for just replicated package (package invalid?)");
            }
            packageId = packageDefinition.getId().toString();
        }
        catch (RepositoryException e) {
            throw new RepositoryException("Could not determine the ID for just replicated package (package invalid?).", (Throwable)e);
        }
        try {
            for (String packagePath : this.packageHelper.getContents(jcrPackage)) {
                Resource resource = resourceResolver.getResource(packagePath);
                if (!this.accept(resource)) continue;
                resources.add(resource);
            }
        }
        catch (IOException | RepositoryException | PackageException e) {
            throw new RepositoryException("Could not retrieve the Packages contents for package '" + packageId + "'", e);
        }
        try {
            if (resources.size() > 0) {
                this.replicationStatusManager.setReplicationStatus(resourceResolver, agentIds, replicatedBy, this.getJcrPackageLastModified(jcrPackage), ReplicationStatusManager.Status.ACTIVATED, resources.toArray(new Resource[resources.size()]));
                log.info("Updated Replication Status for JCR Package: {}", (Object)packageId);
            } else {
                log.info("Could not find any resources in JCR Package [ {} ] that are candidates to have their Replication Status updated", (Object)packageId);
            }
        }
        catch (IOException | RepositoryException e) {
            String paths = resources.stream().map(r -> r.getPath()).limit(10L).collect(Collectors.joining(", "));
            throw new RepositoryException("Exception occurred updating replication status for contents of package '" + packageId + "' covering paths: '" + paths + ", ...'", e);
        }
    }

    protected final Map<String, Object> getInfoFromEvent(Event event) {
        HashMap<String, Object> eventConfig = new HashMap<String, Object>();
        ReplicationAction replicationAction = ReplicationAction.fromEvent((Event)event);
        if (replicationAction != null) {
            String userId;
            String[] paths = replicationAction.getPaths();
            if (paths == null) {
                paths = ArrayUtils.EMPTY_STRING_ARRAY;
            }
            if (StringUtils.isBlank((String)(userId = replicationAction.getUserId()))) {
                userId = StringUtils.defaultIfEmpty((String)this.replicatedByOverride, (String)FALLBACK_REPLICATION_USER_ID);
            }
            eventConfig.put(PROPERTY_PATHS, paths);
            eventConfig.put(PROPERTY_REPLICATED_BY, userId);
            eventConfig.put(PROPERTY_AGENT_IDS, (List)event.getProperty("agentIds"));
        } else {
            ReplicationEvent replicationEvent = ReplicationEvent.fromEvent((Event)event);
            replicationAction = replicationEvent.getReplicationAction();
            eventConfig.put(PROPERTY_PATHS, replicationAction.getPaths());
            eventConfig.put(PROPERTY_REPLICATED_BY, replicationAction.getUserId());
        }
        return eventConfig;
    }

    private boolean containsJcrPackagePath(String path) {
        return StringUtils.startsWith((String)path, (String)"/etc/packages/") && StringUtils.endsWith((String)path, (String)".zip");
    }

    private JcrPackage getJcrPackage(ResourceResolver resourceResolver, String path) {
        Resource eventResource = resourceResolver.getResource(path);
        if (eventResource == null) {
            log.warn("Could not find resource at path [ {} ] with the mapped service user. Either the resource has been removed meanwhile or the service user does not have the necessary rights.", (Object)path);
            return null;
        }
        JcrPackage jcrPackage = null;
        try {
            jcrPackage = this.packaging.open((Node)eventResource.adaptTo(Node.class), false);
        }
        catch (RepositoryException e) {
            log.warn("Error checking if the path [ {} ] is a JCR Package.", (Object)path);
        }
        return jcrPackage;
    }

    private boolean accept(Resource resource) throws RepositoryException {
        if (resource == null || ResourceUtil.isNonExistingResource((Resource)resource)) {
            return false;
        }
        for (Map.Entry<String, Pattern> nodeTypeAndPathRestriction : this.pathRestrictionByNodeType.entrySet()) {
            String[] hierarchyNodeTypes = StringUtils.split((String)nodeTypeAndPathRestriction.getKey(), (String)"/");
            boolean match = true;
            Resource walkingResource = resource;
            for (int i = hierarchyNodeTypes.length - 1; i >= 0; --i) {
                if (walkingResource == null) {
                    match = false;
                    break;
                }
                Node node = (Node)walkingResource.adaptTo(Node.class);
                if (node == null || !node.isNodeType(hierarchyNodeTypes[i])) {
                    match = false;
                    break;
                }
                walkingResource = walkingResource.getParent();
            }
            if (!match) continue;
            Pattern pathRestriction = nodeTypeAndPathRestriction.getValue();
            if (pathRestriction != null && !pathRestriction.matcher(resource.getPath()).matches()) {
                log.debug("Path restriction '{}' prevents the resource at '{}' from getting its replication status updated!", (Object)pathRestriction, (Object)resource.getPath());
                return false;
            }
            return true;
        }
        return false;
    }

    private Calendar getJcrPackageLastModified(JcrPackage jcrPackage) throws RepositoryException, IOException {
        if (ReplicatedAt.CURRENT_TIME.equals((Object)this.replicatedAt)) {
            return Calendar.getInstance();
        }
        return jcrPackage.getPackage().getCreated();
    }

    @Activate
    protected void activate(Map<String, String> config) throws LoginException {
        log.trace("Activating the ACS AEM Commons - JCR Package Replication Status Updater (Event Handler)");
        this.replicatedByOverride = PropertiesUtil.toString((Object)config.get(PROP_REPLICATED_BY_OVERRIDE), (String)PropertiesUtil.toString((Object)config.get(LEGACY_PROP_REPLICATED_BY_OVERRIDE), (String)DEFAULT_REPLICATED_BY_OVERRIDE));
        String tmp = PropertiesUtil.toString((Object)config.get(PROP_REPLICATED_AT), (String)DEFAULT_REPLICATED_BY_OVERRIDE);
        try {
            this.replicatedAt = ReplicatedAt.valueOf(tmp);
        }
        catch (IllegalArgumentException ex) {
            this.replicatedAt = ReplicatedAt.PACKAGE_LAST_MODIFIED;
        }
        String[] nodeTypeAndPathRestrictions = PropertiesUtil.toStringArray((Object)config.get(PROP_REPLICATION_STATUS_NODE_TYPES), (String[])DEFAULT_REPLICATION_STATUS_NODE_TYPES);
        this.pathRestrictionByNodeType = new LinkedHashMap<String, Pattern>();
        for (String nodeTypeAndPathRestrictionEntry : nodeTypeAndPathRestrictions) {
            Map.Entry<String, String> nodeTypeAndPathRestriction = ParameterUtil.toMapEntryWithOptionalValue(nodeTypeAndPathRestrictionEntry, " ");
            Pattern pathRestrictionPattern = StringUtils.isNotBlank((String)nodeTypeAndPathRestriction.getValue()) ? Pattern.compile(nodeTypeAndPathRestriction.getValue()) : null;
            this.pathRestrictionByNodeType.put(nodeTypeAndPathRestriction.getKey(), pathRestrictionPattern);
        }
        log.info("Package Replication Status - Replicated By Override User: [ {} ]", (Object)this.replicatedByOverride);
        log.info("Package Replication Status - Replicated At: [ {} ]", (Object)this.replicatedAt);
        log.info("Package Replication Status - Node Types and Path Restrictions: [ {} ]", this.pathRestrictionByNodeType);
    }

    protected void bindPackaging(Packaging packaging) {
        this.packaging = packaging;
    }

    protected void unbindPackaging(Packaging packaging) {
        if (this.packaging == packaging) {
            this.packaging = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindReplicationStatusManager(ReplicationStatusManager replicationStatusManager) {
        this.replicationStatusManager = replicationStatusManager;
    }

    protected void unbindReplicationStatusManager(ReplicationStatusManager replicationStatusManager) {
        if (this.replicationStatusManager == replicationStatusManager) {
            this.replicationStatusManager = null;
        }
    }

    protected void bindPackageHelper(PackageHelper packageHelper) {
        this.packageHelper = packageHelper;
    }

    protected void unbindPackageHelper(PackageHelper packageHelper) {
        if (this.packageHelper == packageHelper) {
            this.packageHelper = null;
        }
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }

    protected void bindClusterLeader(ClusterLeader clusterLeader) {
        this.clusterLeader = clusterLeader;
    }

    protected void unbindClusterLeader(ClusterLeader clusterLeader) {
        if (this.clusterLeader == clusterLeader) {
            this.clusterLeader = null;
        }
    }

    private static enum ReplicatedAt {
        CURRENT_TIME,
        PACKAGE_LAST_MODIFIED;

    }
}

