/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import com.adobe.acs.commons.redirects.filter.RedirectFilterMBean;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class UpgradeLegacyRedirects {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String REDIRECTS_HOME_5_0_4 = "/conf/acs-commons/redirects";
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd MMMM yyyy", Locale.ENGLISH);
    private boolean moved;
    @SlingObject
    private SlingHttpServletRequest request;
    @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL)
    private RedirectFilterMBean redirectFilter;

    @PostConstruct
    protected void init() {
        ResourceResolver resolver = this.request.getResourceResolver();
        Resource legacyHome = resolver.getResource(REDIRECTS_HOME_5_0_4);
        if (legacyHome == null) {
            return;
        }
        this.moved = (Boolean)legacyHome.getValueMap().get("moved", (Object)false);
        if (this.moved) {
            return;
        }
        String bucketName = this.redirectFilter == null ? "settings" : this.redirectFilter.getBucket();
        String configName = this.redirectFilter == null ? "redirects" : this.redirectFilter.getConfigName();
        String globalPath = "/conf/global/" + bucketName + "/" + configName;
        Resource globalConf = resolver.getResource(globalPath);
        if (globalConf == null) {
            return;
        }
        try {
            int numMoved = 0;
            for (Resource ch : legacyHome.getChildren()) {
                if (!ch.isResourceType("acs-commons/components/utilities/manage-redirects/redirect-row")) continue;
                this.move(ch, globalConf);
                ++numMoved;
            }
            if (numMoved > 0) {
                this.moved = true;
                ((ModifiableValueMap)legacyHome.adaptTo(ModifiableValueMap.class)).put((Object)"moved", (Object)true);
                resolver.commit();
            }
        }
        catch (Exception e) {
            log.error("failed to move {} to {}", new Object[]{REDIRECTS_HOME_5_0_4, globalPath, e});
            resolver.revert();
        }
    }

    void move(Resource legacyRedirect, Resource globalConf) throws PersistenceException {
        String str;
        Calendar c;
        String nodeName = ResourceUtil.createUniqueChildName((Resource)globalConf, (String)legacyRedirect.getName());
        HashMap<String, Calendar> props = new HashMap<String, Calendar>((Map<String, Calendar>)legacyRedirect.getValueMap());
        Object untilDate = props.get("untilDate");
        if (untilDate instanceof String && !StringUtils.isEmpty((CharSequence)((String)untilDate)) && (c = UpgradeLegacyRedirects.toCalendar(str = (String)untilDate)) != null) {
            props.put("untilDate", c);
        }
        ResourceResolver resolver = legacyRedirect.getResourceResolver();
        Resource r = resolver.create(globalConf, nodeName, props);
        resolver.delete(legacyRedirect);
        log.debug("moved {} to {}", (Object)legacyRedirect.getPath(), (Object)r.getPath());
    }

    public boolean isMoved() {
        return this.moved;
    }

    static Calendar toCalendar(String dateStr) {
        GregorianCalendar calendar = null;
        if (!StringUtils.isEmpty((CharSequence)dateStr)) {
            try {
                LocalDate ld = DATE_FORMATTER.parse(dateStr).query(LocalDate::from);
                if (ld != null) {
                    ZonedDateTime zdt = ld.atStartOfDay().plusDays(1L).minusSeconds(1L).atZone(ZoneId.systemDefault());
                    calendar = GregorianCalendar.from(zdt);
                }
            }
            catch (DateTimeParseException e) {
                log.error("Invalid UntilDateTime {}", (Object)dateStr, (Object)e);
            }
        }
        return calendar;
    }
}

