/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.model;

import com.adobe.acs.commons.mcp.model.ValueFormat;
import com.adobe.acs.commons.mcp.util.StringUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public abstract class AbstractReport {
    protected List<String> columnsData;
    protected List<ValueMap> rowsData;
    protected String nameData = "report";

    public abstract void persist(ResourceResolver var1, String var2) throws PersistenceException, RepositoryException;

    public <E extends Enum<E>, V> void setRows(Map<String, EnumMap<E, V>> reportData, String keyName, Class<E> enumClass) throws PersistenceException, RepositoryException {
        this.getColumns().clear();
        this.getColumns().add(keyName);
        Stream.of(new Object[0]).map(Object::toString).collect(Collectors.toCollection(this::getColumns));
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            this.getColumns().add(e.toString());
            ValueFormat format = ValueFormat.forField(e);
            if (format.columnCount <= 1) continue;
            this.getColumns().add(e.toString() + format.suffix);
        }
        this.getRows().clear();
        reportData.forEach((path, row) -> {
            LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>();
            rowData.put(keyName, path);
            for (Enum c : (Enum[])enumClass.getEnumConstants()) {
                if (!row.containsKey(c)) continue;
                ValueFormat format = ValueFormat.forField(c);
                rowData.put(c.toString(), row.get(c));
                if (format.columnCount <= 1) continue;
                rowData.put(c.toString() + format.suffix, format.getAlternateValue(row.get(c)));
            }
            this.getRows().add((ValueMap)new ValueMapDecorator(rowData));
        });
    }

    public <E extends Enum<E>, V> void setRows(List<EnumMap<E, V>> reportData, Class<E> enumClass) throws PersistenceException, RepositoryException {
        this.getColumns().clear();
        Stream.of(new Object[0]).map(Object::toString).collect(Collectors.toCollection(this::getColumns));
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            this.getColumns().add(e.toString());
            ValueFormat format = ValueFormat.forField(e);
            if (format.columnCount <= 1) continue;
            this.getColumns().add(e.toString() + format.suffix);
        }
        this.getRows().clear();
        reportData.forEach(row -> {
            LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>();
            for (Enum c : (Enum[])enumClass.getEnumConstants()) {
                if (!row.containsKey(c)) continue;
                ValueFormat format = ValueFormat.forField(c);
                rowData.put(c.toString(), row.get(c));
                if (format.columnCount <= 1) continue;
                rowData.put(c.toString() + format.suffix, format.getAlternateValue(row.get(c)));
            }
            this.getRows().add((ValueMap)new ValueMapDecorator(rowData));
        });
    }

    public List<String> getColumns() {
        if (this.columnsData == null) {
            this.columnsData = new ArrayList<String>();
        }
        return this.columnsData;
    }

    public List<ValueMap> getRows() {
        if (this.rowsData == null) {
            this.rowsData = new ArrayList<ValueMap>();
        }
        return this.rowsData;
    }

    public String getName() {
        return this.nameData;
    }

    public void setName(String name) {
        this.nameData = name;
    }

    public List<String> getColumnNames() {
        return this.columnsData.stream().map(StringUtil::getFriendlyName).collect(Collectors.toList());
    }
}

