/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.util.visitors.TreeFilteringResourceVisitor;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class ProcessCleanup
extends ProcessDefinition {
    @FormField(name="Age", description="Minimum age (in days) to be considered for removal.", hint="e.g. 7 will remove anything from a week ago or earlier", options={"default=7"})
    public int miniumumAge;

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        instance.defineAction("Remove old instances", rr, this::performCleanupActivity);
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
    }

    @Override
    public void init() throws RepositoryException {
    }

    private void performCleanupActivity(ActionManager manager) throws Exception {
        Calendar c = Calendar.getInstance();
        c.clear(11);
        c.clear(12);
        c.clear(13);
        c.add(5, -this.miniumumAge);
        manager.withResolver(rr -> {
            TreeFilteringResourceVisitor visitor = new TreeFilteringResourceVisitor();
            visitor.setLeafVisitor((res, level) -> {
                if (this.isCreatedDateBefore((Resource)res, c)) {
                    String path = res.getPath();
                    manager.deferredWithResolver(rr2 -> rr2.delete(rr2.getResource(path)));
                }
            });
            visitor.accept(rr.getResource("/var/acs-commons/mcp/instances"));
        });
    }

    private boolean isCreatedDateBefore(Resource res, Calendar threshold) {
        Date created = (Date)res.getValueMap().get("jcr:created", Date.class);
        Calendar createDate = Calendar.getInstance();
        createDate.setTime(created);
        return createDate.before(threshold);
    }
}

