/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl;

import com.adobe.acs.commons.mcp.ControlledProcessManager;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.util.DeserializeException;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"acs-commons/components/utilities/manage-controlled-processes"}, selectors={"start", "list", "status", "halt", "haltAll", "purge"}, methods={"GET", "POST"}, extensions={"json"})
public class ControlledProcessManagerServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ControlledProcessManagerServlet.class);
    private static final Collection<Class> IGNORED_CLASSES = Arrays.asList(Logger.class, Resource.class, ResourceResolver.class, byte[].class);
    private static final Collection<String> IGNORED_PACKAGES = Arrays.asList("java.io");
    private static final List<String> IGNORED_SERVLET_INPUTS = Arrays.asList("definition", "description", "action");
    @Reference
    transient ControlledProcessManager manager;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Object result = null;
        try {
            String action = request.getRequestPathInfo().getSelectorString();
            if (action == null) {
                throw new ServletException("action not provided in url selector");
            }
            switch (action) {
                case "start": {
                    result = this.doStartProcess(request);
                    break;
                }
                case "list": {
                    result = this.doProcessList();
                    break;
                }
                case "status": {
                    result = this.doProcessStatusCheck(request);
                    break;
                }
                case "halt": {
                    result = this.doHaltProcess(request);
                    break;
                }
                case "haltAll": 
                case "halt.all": 
                case "halt-all": {
                    result = this.doHaltAllProcesses();
                    break;
                }
                case "purge": {
                    result = this.doPurgeCompleted();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Action not understood.");
                }
            }
        }
        catch (Exception ex) {
            result = "Exception occurred " + ex.getMessage();
            LOG.error(ex.getMessage() + " -- End of line.", (Throwable)ex);
        }
        String json = this.getGson().toJson(result);
        response.getWriter().write(json);
    }

    Gson getGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.addSerializationExclusionStrategy(new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes fa) {
                return fa.hasModifier(128) || fa.hasModifier(64);
            }

            public boolean shouldSkipClass(Class<?> type) {
                return IGNORED_CLASSES.contains(type) || type.getPackage() != null && IGNORED_PACKAGES.contains(type.getPackage().getName());
            }
        });
        gsonBuilder.disableInnerClassSerialization();
        Gson gson = gsonBuilder.create();
        return gson;
    }

    private ProcessInstance doStartProcess(SlingHttpServletRequest request) throws RepositoryException, ReflectiveOperationException, DeserializeException {
        String def = request.getParameter("definition");
        String description = request.getParameter("description");
        ProcessDefinition definition = this.manager.findDefinitionByNameOrPath(def);
        ProcessInstance instance = this.manager.createManagedProcessInstance(definition, description);
        instance.init(request.getResourceResolver(), this.convertRequestMap(request.getRequestParameterMap()));
        instance.run(request.getResourceResolver());
        return instance;
    }

    private List<ProcessInstance> doProcessStatusCheck(SlingHttpServletRequest request) {
        ProcessInstance instance = this.getProcessFromRequest(request);
        if (instance == null) {
            return this.getProcessesFromRequest(request);
        }
        return Arrays.asList(instance);
    }

    private Object doHaltProcess(SlingHttpServletRequest request) {
        ProcessInstance instance = this.getProcessFromRequest(request);
        if (instance != null) {
            instance.halt();
        }
        return instance;
    }

    private boolean doHaltAllProcesses() {
        this.manager.haltActiveProcesses();
        return true;
    }

    private boolean doPurgeCompleted() {
        this.manager.purgeCompletedProcesses();
        return true;
    }

    private ProcessInstance getProcessFromRequest(SlingHttpServletRequest request) {
        String id = request.getParameter("id");
        if (id != null) {
            return this.manager.getManagedProcessInstanceByIdentifier(id);
        }
        String path = request.getParameter("path");
        if (path != null) {
            return this.manager.getManagedProcessInstanceByPath(path);
        }
        return null;
    }

    private List<ProcessInstance> getProcessesFromRequest(SlingHttpServletRequest request) {
        String[] ids = request.getParameterValues("ids");
        if (ids != null) {
            return Stream.of(ids).map(this.manager::getManagedProcessInstanceByIdentifier).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    Map<String, Object> convertRequestMap(RequestParameterMap requestParameterMap) {
        return requestParameterMap.entrySet().stream().filter(entry -> !IGNORED_SERVLET_INPUTS.contains(entry.getKey())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> {
            RequestParameter[] values = (RequestParameter[])entry.getValue();
            if (values.length == 1) {
                if (values[0].getFileName() != null) {
                    return values[0];
                }
                return values[0].getString();
            }
            return Arrays.stream(values).map(RequestParameter::getString).collect(Collectors.toList());
        }));
    }

    private Collection<ProcessInstance> doProcessList() {
        ArrayList<ProcessInstance> processes = new ArrayList<ProcessInstance>();
        processes.addAll(this.manager.getActiveProcesses());
        processes.addAll(this.manager.getInactiveProcesses());
        processes.sort(Comparator.comparing(p -> p.getInfo().getStartTime()).reversed());
        return processes;
    }

    protected void bindManager(ControlledProcessManager controlledProcessManager) {
        this.manager = controlledProcessManager;
    }

    protected void unbindManager(ControlledProcessManager controlledProcessManager) {
        if (this.manager == controlledProcessManager) {
            this.manager = null;
        }
    }
}

