/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.json;

import com.adobe.acs.commons.json.AbstractJSONObjectVisitor;
import com.adobe.acs.commons.json.JcrJsonAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jcr.Node;
import org.apache.sling.api.resource.Resource;

public class JsonObjectUtil {
    private JsonObjectUtil() {
    }

    public static JsonObject toJsonObject(String json) {
        JsonParser parse = new JsonParser();
        return parse.parse(json).getAsJsonObject();
    }

    public static JsonObject toJsonObject(Resource resource) {
        return JsonObjectUtil.toJsonObject(resource.adaptTo(Node.class));
    }

    public static JsonObject toJsonObject(Object source) {
        if (source instanceof String) {
            return JsonObjectUtil.toJsonObject((String)source);
        }
        if (source instanceof Resource) {
            return JsonObjectUtil.toJsonObject((Resource)source);
        }
        Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Node.class, (Object)new JcrJsonAdapter()).create();
        return gson.toJsonTree(source).getAsJsonObject();
    }

    public static <T> JsonObject toJsonObject(T source, int depth) {
        JsonObject obj = JsonObjectUtil.toJsonObject(source);
        JsonObjectUtil.pruneToDepth(obj, depth);
        return obj;
    }

    public static void pruneToDepth(JsonObject obj, final int depth) {
        AbstractJSONObjectVisitor prune = new AbstractJSONObjectVisitor(){

            @Override
            protected void visit(JsonObject jsonObject) {
                if (this.getCurrentDepth() >= depth) {
                    Set<String> allKeys = jsonObject.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
                    allKeys.forEach(arg_0 -> ((JsonObject)jsonObject).remove(arg_0));
                }
            }
        };
        prune.accept(obj);
    }

    public static <T> String getAsJsonString(T source, int depth) {
        Gson gson = new Gson();
        JsonObject object = JsonObjectUtil.toJsonObject(source, depth);
        return gson.toJson((JsonElement)object);
    }

    public static boolean isSingularElement(JsonElement elem) {
        return elem.isJsonPrimitive() || elem.isJsonArray() && elem.getAsJsonArray().size() <= 1;
    }

    public static Optional<JsonElement> getOptional(JsonObject obj, String prop) {
        return Optional.ofNullable(obj.get(prop));
    }

    public static <T> T getOptionalProperty(JsonObject obj, String prop, Function<JsonElement, T> getter, T defaultValue) {
        return JsonObjectUtil.getOptional(obj, prop).filter(JsonObjectUtil::isSingularElement).map(getter).orElse(defaultValue);
    }

    public static Optional<JsonObject> getOptionalObject(JsonObject obj, String prop) {
        return Optional.ofNullable(obj.getAsJsonObject(prop));
    }

    public static String getString(JsonObject obj, String prop, String defaultValue) {
        return JsonObjectUtil.getOptionalProperty(obj, prop, JsonElement::getAsString, defaultValue);
    }

    public static String getString(JsonObject obj, String prop) {
        return JsonObjectUtil.getOptionalProperty(obj, prop, JsonElement::getAsString, "");
    }

    public static Long getLong(JsonObject obj, String prop, Long defaultValue) {
        return JsonObjectUtil.getOptionalProperty(obj, prop, JsonElement::getAsLong, defaultValue);
    }

    public static Long getLong(JsonObject obj, String prop) {
        return JsonObjectUtil.getOptionalProperty(obj, prop, JsonElement::getAsLong, null);
    }

    public static Integer getInteger(JsonObject obj, String prop, Integer defaultValue) {
        return JsonObjectUtil.getOptionalProperty(obj, prop, JsonElement::getAsInt, defaultValue);
    }

    public static Integer getInteger(JsonObject obj, String prop) {
        return JsonObjectUtil.getOptionalProperty(obj, prop, JsonElement::getAsInt, null);
    }

    public static Boolean getBoolean(JsonObject obj, String prop, Boolean defaultValue) {
        return JsonObjectUtil.getOptionalProperty(obj, prop, JsonElement::getAsBoolean, defaultValue);
    }

    public static Boolean getBoolean(JsonObject obj, String prop) {
        return JsonObjectUtil.getOptionalProperty(obj, prop, JsonElement::getAsBoolean, null);
    }
}

