/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfigExtension;
import com.adobe.acs.commons.httpcache.config.impl.AbstractKeyValueExtension;
import com.adobe.acs.commons.httpcache.keys.CacheKeyFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={HttpCacheConfigExtension.class, CacheKeyFactory.class}, property={"service.ranking:Integer=20"})
@Designate(ocd=Config.class, factory=true)
public class RequestHeaderHttpCacheConfigExtension
extends AbstractKeyValueExtension
implements CacheKeyFactory,
HttpCacheConfigExtension {
    private Map<String, String[]> allowedHeaders;
    private String cacheKeyId;

    @Override
    public Map<String, String[]> getAllowedKeyValues() {
        return this.allowedHeaders;
    }

    @Override
    public boolean accepts(SlingHttpServletRequest request, HttpCacheConfig cacheConfig, Map<String, String[]> allowedKeyValues) {
        for (Map.Entry<String, String[]> entry : allowedKeyValues.entrySet()) {
            String header = request.getHeader(entry.getKey());
            if (header == null || !ArrayUtils.isEmpty((Object[])entry.getValue()) && !ArrayUtils.contains((Object[])entry.getValue(), (Object)header)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getActualValue(String key, SlingHttpServletRequest request) {
        return request.getHeader(key);
    }

    @Override
    public String getCacheKeyId() {
        return "[Request Header: " + this.cacheKeyId + "]";
    }

    @Activate
    public void activate(Config config) {
        this.allowedHeaders = new HashMap<String, String[]>();
        this.allowedHeaders.put(config.httpcache_config_extension_requestheader(), config.httpcache_config_extension_requestheader_values());
        this.cacheKeyId = UUID.randomUUID().toString();
    }

    @ObjectClassDefinition(name="ACS AEM Commons - HTTP Cache - Extension - Request Header", description="Defined Request headers / Request header values that will be allowed for this extension (HttpCacheConfig and CacheKeyFactory).")
    public static @interface Config {
        @AttributeDefinition(name="Allowed Request Header", description="The HTTP Request Header to check.")
        public String httpcache_config_extension_requestheader() default "";

        @AttributeDefinition(name="Allowed Request Header values", description="This request is only accepted for caching when its named request header (above) contains one of these values. Leave blank for any value.")
        public String[] httpcache_config_extension_requestheader_values() default {};

        @AttributeDefinition(name="Config Name")
        public String config_name() default "";

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "Request Headers: [ {httpcache.config.extension.requestheader} ] Request Header values: [ {httpcache.config.extension.requestheader.values} ] Config name: [ {config.name} ]";
    }
}

