/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfigExtension;
import com.adobe.acs.commons.httpcache.config.impl.AbstractKeyValueExtension;
import com.adobe.acs.commons.httpcache.keys.CacheKeyFactory;
import com.adobe.acs.commons.util.CookieUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={HttpCacheConfigExtension.class, CacheKeyFactory.class}, property={"service.ranking:Integer=30"})
@Designate(ocd=Config.class, factory=true)
public class RequestCookieHttpCacheConfigExtension
extends AbstractKeyValueExtension
implements HttpCacheConfigExtension,
CacheKeyFactory {
    private static final Logger log = LoggerFactory.getLogger(RequestCookieHttpCacheConfigExtension.class);
    private Map<String, String[]> allowedCookies;
    private String cacheKeyId;

    @Override
    public Map<String, String[]> getAllowedKeyValues() {
        return this.allowedCookies;
    }

    @Override
    public boolean accepts(SlingHttpServletRequest request, HttpCacheConfig cacheConfig, Map<String, String[]> allowedKeyValues) {
        for (Map.Entry<String, String[]> entry : allowedKeyValues.entrySet()) {
            Cookie cookie = CookieUtil.getCookie((HttpServletRequest)request, entry.getKey());
            if (cookie == null) continue;
            if (ArrayUtils.isEmpty((Object[])entry.getValue())) {
                log.debug("Accepting as cacheable due to existence of Cookie [ {} ]", (Object)entry.getKey());
                return true;
            }
            if (!ArrayUtils.contains((Object[])entry.getValue(), (Object)cookie.getValue())) continue;
            log.debug("Accepting as cacheable due to existence of Cookie [ {} ] with value [ {} ]", (Object)entry.getKey(), (Object)cookie.getValue());
            return true;
        }
        log.debug("Could not find any valid Cookie matches for HTTP Cache");
        return false;
    }

    @Override
    protected String getActualValue(String key, SlingHttpServletRequest request) {
        Cookie cookie = CookieUtil.getCookie((HttpServletRequest)request, key);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public String getCacheKeyId() {
        return "[Cookie: " + this.cacheKeyId + "]";
    }

    @Activate
    @Modified
    protected void activate(Config config) {
        this.allowedCookies = new HashMap<String, String[]>();
        this.allowedCookies.put(config.httpcache_config_extension_cookie(), config.httpcache_config_extension_cookie_values());
        this.cacheKeyId = UUID.randomUUID().toString();
    }

    @ObjectClassDefinition(name="ACS AEM Commons - HTTP Cache - Extension - Cookies", description="Defines Cookie names / values that will be allowed for this extension (HttpCacheConfig and CacheKeyFactory).")
    public static @interface Config {
        @AttributeDefinition(name="Allowed Cookie", description="The HTTP Request Cookie name to check.")
        public String httpcache_config_extension_cookie() default "";

        @AttributeDefinition(name="Allowed Cookie Values", description="This request is only accepted for caching when its named cookie (above) contains one of these values. Leave blank for any value.")
        public String[] httpcache_config_extension_cookie_values() default {};

        @AttributeDefinition(name="Config Name")
        public String config_name() default "";

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "Cookie name: [ {httpcache.config.extension.cookie} ] Cookie values: [  {httpcache.config.extension.cookie.values} ] Config name: [ {config.name} ]";
    }
}

