/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam.actions;

import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.functions.CheckedBiFunction;
import com.adobe.acs.commons.functions.CheckedFunction;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class Filters {
    public static final String ORIGINAL_RENDITION = "original";
    public static final CheckedFunction<Boolean, Boolean> NOT = t -> t == false;
    public static final CheckedBiFunction<ResourceResolver, String, Boolean> FILTER_OUT_SUBASSETS = Filters.filterNotMatching(".*?/subassets/.*");
    public static final CheckedBiFunction<ResourceResolver, String, Boolean> FILTER_NON_ASSETS = (r, path) -> {
        Actions.nameThread("filterNonAssets-" + path);
        Resource res = r.getResource(path);
        return DamUtil.resolveToAsset((Resource)res) != null;
    };
    public static final CheckedBiFunction<ResourceResolver, String, Boolean> FILTER_ASSETS_WITH_OUTDATED_RENDITIONS = (r, path) -> {
        Actions.nameThread("filterAssetsWithOutdatedRenditions-" + path);
        Resource res = r.getResource(path);
        Asset asset = DamUtil.resolveToAsset((Resource)res);
        if (asset == null) {
            return false;
        }
        Rendition original = asset.getRendition(ORIGINAL_RENDITION);
        if (original == null) {
            return false;
        }
        long originalTime = original.getResourceMetadata().getCreationTime();
        int counter = 0;
        for (Rendition rendition : asset.getRenditions()) {
            ++counter;
            long time = rendition.getResourceMetadata().getCreationTime();
            if (time >= originalTime) continue;
            return true;
        }
        return counter <= 1;
    };

    private Filters() {
    }

    public static final CheckedBiFunction<ResourceResolver, String, Boolean> filterMatching(String glob) {
        return (r, path) -> path.matches(glob);
    }

    public static final CheckedBiFunction<ResourceResolver, String, Boolean> filterNotMatching(String glob) {
        return Filters.filterMatching(glob).andThen(NOT);
    }
}

