/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.exporters.impl.users;

import com.adobe.acs.commons.exporters.impl.users.Parameters;
import com.day.text.csv.Csv;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"GET"}, resourceTypes={"acs-commons/components/utilities/exporters/users-to-csv"}, selectors={"export"}, extensions={"csv"})
public class UsersExportServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(UsersExportServlet.class);
    private static final String QUERY = "SELECT * FROM [rep:User] ORDER BY [rep:principalName]";
    private static final String GROUP_DELIMITER = "|";

    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/csv");
        response.setCharacterEncoding("UTF-8");
        Parameters parameters = new Parameters(request);
        log.debug("Users to CSV Export Parameters: {}", (Object)parameters);
        Csv csv = new Csv();
        PrintWriter writer = response.getWriter();
        csv.writeInit((Writer)writer);
        Iterator resources = request.getResourceResolver().findResources(QUERY, "JCR-SQL2");
        LinkedHashMap<String, CsvUser> csvUsers = new LinkedHashMap<String, CsvUser>();
        while (resources.hasNext()) {
            try {
                Resource resource = (Resource)resources.next();
                CsvUser csvUser = new CsvUser(resource);
                if (csvUsers.containsKey(csvUser.getPath()) || !this.checkGroups(parameters.getGroups(), parameters.getGroupFilter(), csvUser)) continue;
                csvUsers.put(csvUser.getPath(), csvUser);
            }
            catch (RepositoryException e) {
                log.error("Unable to extract a user from resource.", (Throwable)e);
            }
        }
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("Path");
        columns.add("User ID");
        columns.add("First Name");
        columns.add("Last Name");
        columns.add("E-mail Address");
        columns.add("Created Date");
        columns.add("Last Modified Date");
        for (String string : parameters.getCustomProperties()) {
            columns.add(string);
        }
        columns.add("All Groups");
        columns.add("Direct Groups");
        columns.add("Indirect Groups");
        csv.writeRow(columns.toArray(new String[columns.size()]));
        for (CsvUser csvUser : ((HashMap)csvUsers).values()) {
            ArrayList<String> values = new ArrayList<String>();
            try {
                values.add(csvUser.getPath());
                values.add(csvUser.getID());
                values.add(csvUser.getFirstName());
                values.add(csvUser.getLastName());
                values.add(csvUser.getEmail());
                values.add(csvUser.getCreatedDate());
                values.add(csvUser.getLastModifiedDate());
                for (String customProperty : parameters.getCustomProperties()) {
                    values.add(csvUser.getCustomProperty(customProperty));
                }
                values.add(StringUtils.join(csvUser.getAllGroups(), (String)GROUP_DELIMITER));
                values.add(StringUtils.join(csvUser.getDeclaredGroups(), (String)GROUP_DELIMITER));
                values.add(StringUtils.join(csvUser.getTransitiveGroups(), (String)GROUP_DELIMITER));
                csv.writeRow(values.toArray(new String[values.size()]));
            }
            catch (RepositoryException repositoryException) {
                log.error("Unable to export user to CSV report", (Throwable)repositoryException);
            }
        }
        csv.close();
    }

    protected boolean checkGroups(String[] groups, String groupFilter, CsvUser csvUser) throws RepositoryException {
        log.debug("Group Filter: {}", (Object)groupFilter);
        if (!ArrayUtils.isEmpty((Object[])groups)) {
            if ("direct".equals(groupFilter) && csvUser.isInDirectGroup(groups)) {
                log.debug("Adding [ {} ] via [ Direct ] membership", (Object)csvUser.getID());
                return true;
            }
            if ("indirect".equals(groupFilter) && csvUser.isInIndirectGroup(groups)) {
                log.debug("Adding [ {} ] via [ Indirect ] membership", (Object)csvUser.getID());
                return true;
            }
            if ("".equals(groupFilter) && (csvUser.isInDirectGroup(groups) || csvUser.isInIndirectGroup(groups))) {
                log.debug("Adding [ {} ] via [ Direct OR Indirect ] membership", (Object)csvUser.getID());
                return true;
            }
            return false;
        }
        log.debug("Adding [ {} ] as no groups were specified to specify membership filtering.", (Object)csvUser.getID());
        return true;
    }

    protected static class CsvUser {
        private final ValueMap properties;
        private Set<String> declaredGroups = new LinkedHashSet<String>();
        private Set<String> transitiveGroups = new LinkedHashSet<String>();
        private Set<String> allGroups = new LinkedHashSet<String>();
        private Authorizable authorizable;
        private String email;
        private String firstName;
        private String lastName;
        private Calendar createdDate;
        private Calendar lastModifiedDate;
        private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

        public CsvUser(Resource resource) throws RepositoryException {
            if (resource == null) {
                throw new IllegalArgumentException("Authorizable object cannot be null");
            }
            UserManager userManager = (UserManager)resource.adaptTo(UserManager.class);
            this.properties = resource.getValueMap();
            this.authorizable = userManager.getAuthorizableByPath(resource.getPath());
            this.declaredGroups = this.getGroupIds(this.authorizable.declaredMemberOf());
            this.transitiveGroups = this.getGroupIds(this.authorizable.memberOf());
            this.allGroups.addAll(this.transitiveGroups);
            this.allGroups.addAll(this.declaredGroups);
            this.transitiveGroups.removeAll(this.declaredGroups);
            this.firstName = (String)this.properties.get("profile/givenName", (Object)"");
            this.lastName = (String)this.properties.get("profile/familyName", (Object)"");
            this.email = (String)this.properties.get("profile/email", (Object)"");
            this.createdDate = (Calendar)this.properties.get("jcr:created", Calendar.class);
            this.lastModifiedDate = (Calendar)this.properties.get("cq:lastModified", Calendar.class);
        }

        public List<String> getDeclaredGroups() {
            return new ArrayList<String>(this.declaredGroups);
        }

        public List<String> getTransitiveGroups() {
            return new ArrayList<String>(this.transitiveGroups);
        }

        public List<String> getAllGroups() {
            return new ArrayList<String>(this.allGroups);
        }

        public String getPath() throws RepositoryException {
            return this.authorizable.getPath();
        }

        public String getID() throws RepositoryException {
            return this.authorizable.getID();
        }

        private Set<String> getGroupIds(Iterator<Group> groups) throws RepositoryException {
            ArrayList<String> groupIDs = new ArrayList<String>();
            while (groups.hasNext()) {
                groupIDs.add(groups.next().getID());
            }
            Collections.sort(groupIDs);
            return new LinkedHashSet<String>(groupIDs);
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getCreatedDate() {
            if (this.createdDate != null) {
                return this.sdf.format(this.createdDate.getTime());
            }
            return "";
        }

        public String getLastModifiedDate() {
            if (this.lastModifiedDate != null) {
                return this.sdf.format(this.lastModifiedDate.getTime());
            }
            return "";
        }

        public String getEmail() {
            return this.email;
        }

        public boolean isInDirectGroup(String ... groups) {
            return CollectionUtils.containsAny(this.getDeclaredGroups(), Arrays.asList(groups));
        }

        public boolean isInIndirectGroup(String ... groups) {
            return CollectionUtils.containsAny(this.getTransitiveGroups(), Arrays.asList(groups));
        }

        public String getCustomProperty(String customProperty) {
            return (String)this.properties.get(customProperty, (Object)"");
        }
    }
}

