/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.errorpagehandler.cache.impl;

import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

class CacheEntry {
    private String data = "";
    private final AtomicInteger hits = new AtomicInteger();
    private final AtomicInteger misses = new AtomicInteger();
    private Date expiresAt = new Date(0L);

    public final String getData() {
        if (this.data == null) {
            return "";
        }
        return this.data;
    }

    public final void setData(String data) {
        this.data = data == null ? "" : data;
    }

    public final int getHits() {
        return this.hits.get();
    }

    public final void incrementHits() {
        this.hits.incrementAndGet();
    }

    public final int getMisses() {
        return this.misses.get();
    }

    public final void incrementMisses() {
        this.misses.incrementAndGet();
    }

    public final boolean isExpired(Date date) {
        return this.expiresAt.before(date);
    }

    public final void setExpiresIn(int expiresInSeconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, expiresInSeconds);
        this.expiresAt = calendar.getTime();
    }

    public final float getHitRate() {
        int total = this.getTotal();
        if (total == 0) {
            return 0.0f;
        }
        return (float)this.getHits() / (float)total;
    }

    public final float getMissRate() {
        int total = this.getTotal();
        if (total == 0) {
            return 0.0f;
        }
        return (float)this.getMisses() / (float)total;
    }

    final int getTotal() {
        return this.hits.get() + this.misses.get();
    }

    final int getBytes() {
        return this.getData().getBytes(Charset.forName("UTF-8")).length;
    }
}

