/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.ccvar.impl;

import com.adobe.acs.commons.ccvar.PropertyConfigService;
import com.adobe.acs.commons.ccvar.TransformAction;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PropertyConfigService.class})
@Designate(ocd=Config.class)
public class PropertyConfigServiceImpl
implements PropertyConfigService {
    public static final String PARSER_SEPARATOR = "!";
    private static final Logger LOG = LoggerFactory.getLogger(PropertyConfigServiceImpl.class);
    private List<Pattern> exclusionList;
    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)
    private List<TransformAction> actions;

    @Override
    public boolean isAllowed(String propertyName) {
        for (Pattern pattern : this.exclusionList) {
            if (!pattern.matcher(propertyName).matches()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllowedType(Object object) {
        return String.class.equals(object.getClass()) || Long.class.equals(object.getClass());
    }

    @Override
    public TransformAction getAction(String key) {
        if (StringUtils.contains((CharSequence)key, (CharSequence)PARSER_SEPARATOR)) {
            String actionName = StringUtils.substringAfter((String)key, (String)PARSER_SEPARATOR);
            for (TransformAction action : this.actions) {
                if (!StringUtils.equals((CharSequence)action.getName(), (CharSequence)actionName)) continue;
                return action;
            }
            LOG.warn("Action specified with name [{}] was not found in map.", (Object)actionName);
        }
        return null;
    }

    @Activate
    protected void activate(Config config) {
        ArrayList<Pattern> excludeList = new ArrayList<Pattern>();
        for (String exclude : config.exclude_list()) {
            if (!StringUtils.isNotBlank((CharSequence)exclude)) continue;
            excludeList.add(Pattern.compile(exclude));
        }
        this.exclusionList = excludeList;
    }

    @ObjectClassDefinition(name="ACS AEM Commons - Contextual Content Variable Property Aggregator Service Configuration")
    static @interface Config {
        @AttributeDefinition(name="Exclude List", description="List of properties to exclude, accepts regex.", type=AttributeType.STRING)
        public String[] exclude_list() default {"cq:.*"};
    }
}

