/*
 * Decompiled with CFR 0.152.
 */
package acscommons.io.jsonwebtoken.gson.io;

import acscommons.io.jsonwebtoken.io.Encoders;
import acscommons.io.jsonwebtoken.io.SerializationException;
import acscommons.io.jsonwebtoken.io.Serializer;
import acscommons.io.jsonwebtoken.lang.Assert;
import acscommons.io.jsonwebtoken.lang.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class GsonSerializer<T>
implements Serializer<T> {
    static final Gson DEFAULT_GSON = new GsonBuilder().disableHtmlEscaping().create();
    private Gson gson;

    public GsonSerializer() {
        this(DEFAULT_GSON);
    }

    public GsonSerializer(Gson gson) {
        Assert.notNull(gson, "gson cannot be null.");
        this.gson = gson;
    }

    @Override
    public byte[] serialize(T t) throws SerializationException {
        Assert.notNull(t, "Object to serialize cannot be null.");
        try {
            return this.writeValueAsBytes(t);
        }
        catch (Exception e) {
            String msg = "Unable to serialize object: " + e.getMessage();
            throw new SerializationException(msg, e);
        }
    }

    protected byte[] writeValueAsBytes(T t) {
        Object o = t instanceof byte[] ? Encoders.BASE64.encode((byte[])t) : (t instanceof char[] ? new String((char[])t) : t);
        return this.gson.toJson(o).getBytes(Strings.UTF_8);
    }
}

