/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.day.cq.wcm.api.PageInfoProvider;
import java.util.Iterator;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class WorkflowModelFilterPageInfoProvider
implements PageInfoProvider {
    private static final String KEY_MODELS = "models";
    private static final String KEY_MODEL_PATH = "wid";
    private static final String KEY_WORKFLOWS = "workflows";
    private static final String PN_ALLOWED_PATHS = "allowedPaths";
    private static final Logger log = LoggerFactory.getLogger(WorkflowModelFilterPageInfoProvider.class);

    public void updatePageInfo(SlingHttpServletRequest request, JSONObject info, Resource resource) throws JSONException {
        if (info.has(KEY_WORKFLOWS)) {
            JSONObject workflows = info.getJSONObject(KEY_WORKFLOWS);
            String resourcePath = resource.getPath();
            ResourceResolver resourceResolver = resource.getResourceResolver();
            Iterator types = workflows.keys();
            while (types.hasNext()) {
                String type = (String)types.next();
                JSONObject typeObject = workflows.getJSONObject(type);
                this.filter(typeObject, resourcePath, resourceResolver);
            }
        } else {
            log.warn("No workflows found in existing page info. Check order of cq:infoProviders.");
        }
    }

    private void filter(JSONObject typeObject, String resourcePath, ResourceResolver resourceResolver) throws JSONException {
        JSONArray models = typeObject.getJSONArray(KEY_MODELS);
        JSONArray newModels = new JSONArray();
        block0: for (int i = 0; i < models.length(); ++i) {
            JSONObject modelObject = models.getJSONObject(i);
            String path = modelObject.getString(KEY_MODEL_PATH);
            Resource modelResource = resourceResolver.getResource(path);
            if (modelResource == null) continue;
            ValueMap properties = modelResource.getParent().getValueMap();
            String[] allowedPaths = (String[])properties.get(PN_ALLOWED_PATHS, String[].class);
            if (allowedPaths == null) {
                newModels.put((Object)modelObject);
                continue;
            }
            for (String allowedPath : allowedPaths) {
                if (!resourcePath.matches(allowedPath)) continue;
                newModels.put((Object)modelObject);
                continue block0;
            }
        }
        typeObject.put(KEY_MODELS, (Object)newModels);
    }
}

