/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.models;

import com.adobe.acs.commons.reports.api.ReportException;
import com.adobe.acs.commons.reports.api.ReportExecutor;
import com.adobe.acs.commons.reports.api.ResultsPage;
import com.adobe.acs.commons.reports.models.PathListReportConfig;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;

@Model(adaptables={SlingHttpServletRequest.class})
public class PathListReportExecutor
implements ReportExecutor {
    int currentPage;
    PathListReportConfig config;
    @Self
    private SlingHttpServletRequest request;
    @SlingObject
    ResourceResolver resourceResolver;

    @Override
    public String getDetails() throws ReportException {
        return "";
    }

    @Override
    public String getParameters() throws ReportException {
        return "";
    }

    List<String> extractPaths() throws ReportException {
        try {
            Template template = new Handlebars().compileInline(this.config.getPathArea());
            String pathsArea = template.apply(this.getParamPatternMap(this.request));
            if (StringUtils.isNotEmpty((CharSequence)pathsArea)) {
                return Arrays.asList(pathsArea.split("\r?\n"));
            }
        }
        catch (IOException ioe) {
            throw new ReportException("Exception templating query", ioe);
        }
        return Collections.emptyList();
    }

    @Override
    public ResultsPage getAllResults() throws ReportException {
        List<Object> results = this.getResources(this.extractPaths());
        return new ResultsPage(results.stream(), this.config.getPageSize(), this.currentPage, results.size());
    }

    @Override
    public ResultsPage getResults() throws ReportException {
        List<String> paths = this.extractPaths();
        List<String> sublistPaths = paths.subList(this.getFrom(this.currentPage), this.getTo(paths.size()));
        List<Object> results = this.getResources(sublistPaths);
        return new ResultsPage(results.stream(), this.config.getPageSize(), this.currentPage, results.size());
    }

    List<Object> getResources(List<String> paths) {
        return Optional.ofNullable(paths).map(Collection::stream).orElseGet(Stream::empty).map(path -> this.resourceResolver.getResource(path)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private int getFrom(int page) {
        return page * this.config.getPageSize();
    }

    private int getTo(int listSize) {
        return Math.min(this.getFrom(this.currentPage + 1), listSize);
    }

    @Override
    public void setConfiguration(Resource config) {
        this.config = (PathListReportConfig)config.adaptTo(PathListReportConfig.class);
    }

    @Override
    public void setPage(int page) {
        this.currentPage = page <= 0 ? 0 : page;
    }
}

