/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.util;

import com.adobe.acs.commons.mcp.form.AbstractResourceImpl;
import java.util.Map;
import org.apache.sling.api.resource.Resource;

public class SyntheticResourceBuilder {
    AbstractResourceImpl rootResource;
    AbstractResourceImpl currentResource;

    public SyntheticResourceBuilder(AbstractResourceImpl start) {
        this.rootResource = this.currentResource = start;
    }

    public SyntheticResourceBuilder(String name, String resourceType) {
        this.currentResource = this.rootResource = new AbstractResourceImpl(name, resourceType, null, null);
    }

    public SyntheticResourceBuilder createChild(String name, String resourceType) {
        AbstractResourceImpl child = new AbstractResourceImpl(name, resourceType, null, null);
        this.currentResource.addChild((Resource)child);
        this.currentResource = child;
        return this;
    }

    public SyntheticResourceBuilder createChild(String name) {
        return this.createChild(name, null);
    }

    public SyntheticResourceBuilder createSibling(String name, String resourceType) {
        return this.up().createChild(name, resourceType);
    }

    public SyntheticResourceBuilder createSibling(String name) {
        return this.createSibling(name, null);
    }

    public SyntheticResourceBuilder withPath(String path) {
        this.currentResource.setPath(path);
        return this;
    }

    public SyntheticResourceBuilder withChild(Resource child) {
        this.currentResource.addChild(child);
        return this;
    }

    public SyntheticResourceBuilder withAttributes(Object ... attrs) {
        for (int i = 0; i < attrs.length - 1; i += 2) {
            this.currentResource.getValueMap().put((Object)String.valueOf(attrs[i]), attrs[i + 1]);
        }
        return this;
    }

    public SyntheticResourceBuilder withAttributes(Map<String, Object> attrs) {
        this.currentResource.getValueMap().putAll(attrs);
        return this;
    }

    public SyntheticResourceBuilder up(int levels) {
        for (int i = 0; i < levels && this.currentResource.getParent() != null; ++i) {
            this.currentResource = (AbstractResourceImpl)this.currentResource.getParent();
        }
        return this;
    }

    public SyntheticResourceBuilder up(String name) {
        while (!this.currentResource.getName().equals(name) && this.currentResource.getParent() != null) {
            this.currentResource = (AbstractResourceImpl)this.currentResource.getParent();
        }
        return this;
    }

    public SyntheticResourceBuilder up() {
        return this.up(1);
    }

    public AbstractResourceImpl build() {
        return this.rootResource;
    }
}

