/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.lang3.reflect.FieldUtils;

public class IntrospectionUtil {
    public static boolean hasMultipleValues(Class clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz);
    }

    public static Class<?> getCollectionComponentType(Field field) {
        if (Collection.class.isAssignableFrom(field.getType())) {
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType t = (ParameterizedType)genericType;
                if (t.getActualTypeArguments().length == 1) {
                    return (Class)t.getActualTypeArguments()[0];
                }
                return null;
            }
            return Object.class;
        }
        if (field.getType().isArray()) {
            return field.getType().getComponentType();
        }
        return field.getType();
    }

    public static boolean isPrimitive(Field field) {
        Class<?> basicType = IntrospectionUtil.getCollectionComponentType(field);
        return basicType != null && (basicType.isPrimitive() || Number.class.isAssignableFrom(basicType) || basicType == String.class);
    }

    public static boolean isSimple(Field field) {
        Class<?> basicType = IntrospectionUtil.getCollectionComponentType(field);
        return basicType != null && (IntrospectionUtil.isPrimitive(field) || basicType.isEnum() || basicType == String.class);
    }

    public static Optional<Object> createObject(Class c) {
        for (Constructor<?> constructor : c.getConstructors()) {
            try {
                Object obj = constructor.newInstance(new Object[constructor.getParameterCount()]);
                return Optional.of(obj);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NullPointerException | InvocationTargetException exception) {
            }
        }
        return Optional.empty();
    }

    public static Optional<Object> getDeclaredValue(AccessibleObject field) {
        Field f;
        Optional<Object> o;
        if (field instanceof Field && (o = IntrospectionUtil.createObject((f = (Field)field).getDeclaringClass())).isPresent()) {
            try {
                return Optional.ofNullable(FieldUtils.readField((Field)f, (Object)o.get(), (boolean)true));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private IntrospectionUtil() {
    }
}

