/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.model;

import com.adobe.acs.commons.mcp.model.AbstractReport;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ChildResource;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class GenericBlobReport
extends AbstractReport {
    @ChildResource
    Resource blobreport;
    @ValueMapValue
    String name;
    @ValueMapValue
    List<String> columns;
    private static final Logger LOG = LoggerFactory.getLogger(GenericBlobReport.class);
    public static final String BLOB_REPORT_RESOURCE_TYPE = "acs-commons/components/utilities/process-instance/process-blob-report";

    public String getResourceType() {
        return BLOB_REPORT_RESOURCE_TYPE;
    }

    @PostConstruct
    public void init() {
        this.columnsData = this.columns;
        this.nameData = this.name;
        ObjectMapper mapper = new ObjectMapper();
        try (InputStream is = (InputStream)this.blobreport.adaptTo(InputStream.class);){
            JsonNode array = mapper.readTree(is);
            if (!array.isArray()) {
                LOG.error("blobreport does not contain a JSON array, not reading any data from {}", (Object)this.blobreport.getPath());
            } else {
                for (JsonNode ar : array) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (String c : this.columns) {
                        if (!ar.has(c) || ar.get(c) == null) continue;
                        map.put(c, ar.get(c).asText());
                    }
                    this.getRows().add((ValueMap)new ValueMapDecorator(map));
                }
            }
        }
        catch (IOException e) {
            LOG.error("Problems during de-serialization of report (path={})", (Object)this.blobreport.getPath(), (Object)e);
        }
    }

    @Override
    public void persist(ResourceResolver rr, String path) throws PersistenceException, RepositoryException {
        block11: {
            ModifiableValueMap jcrContent = (ModifiableValueMap)ResourceUtil.getOrCreateResource((ResourceResolver)rr, (String)path, (String)this.getResourceType(), null, (boolean)false).adaptTo(ModifiableValueMap.class);
            jcrContent.put((Object)"jcr:primaryType", (Object)"nt:unstructured");
            jcrContent.put((Object)"columns", (Object)this.getColumns().toArray(new String[0]));
            jcrContent.put((Object)"name", (Object)this.getName());
            ObjectMapper mapper = new ObjectMapper();
            ArrayNode jsonRows = new ArrayNode(JsonNodeFactory.instance);
            for (Map row : this.rowsData) {
                Map<String, Object> properties = row.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                JsonNode elem = (JsonNode)mapper.convertValue(properties, JsonNode.class);
                jsonRows.add(elem);
            }
            Node parent = Optional.ofNullable(rr.getResource(path)).map(resource -> (Node)resource.adaptTo(Node.class)).orElse(null);
            if (parent != null) {
                try {
                    String jsonString = mapper.writeValueAsString((Object)jsonRows);
                    try (InputStream is = IOUtils.toInputStream((String)jsonString, (Charset)Charset.defaultCharset());){
                        JcrUtils.putFile((Node)parent, (String)"blobreport", (String)"text/json", (InputStream)is);
                        rr.commit();
                        break block11;
                    }
                }
                catch (JsonProcessingException ex) {
                    throw new PersistenceException("Cannot convert Json to String", (Throwable)ex);
                }
                catch (IOException ioe) {
                    throw new PersistenceException("Cannot close inputstream for report", (Throwable)ioe);
                }
            }
            LOG.error("{} is not a JCR path, cannot persist report", (Object)path);
        }
    }
}

