/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.caffeine.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.engine.CacheContent;
import com.adobe.acs.commons.httpcache.exception.HttpCacheDataStreamException;
import com.adobe.acs.commons.httpcache.exception.HttpCacheKeyCreationException;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.store.HttpCacheStore;
import com.adobe.acs.commons.httpcache.store.TempSink;
import com.adobe.acs.commons.httpcache.store.caffeine.impl.AbstractCaffeineCacheMBean;
import com.adobe.acs.commons.httpcache.store.caffeine.impl.CacheExpiryPolicy;
import com.adobe.acs.commons.httpcache.store.caffeine.impl.CaffeineCacheMBean;
import com.adobe.acs.commons.httpcache.store.mem.impl.MemCachePersistenceObject;
import com.adobe.acs.commons.httpcache.store.mem.impl.MemTempSinkImpl;
import com.adobe.acs.commons.util.impl.exception.CacheMBeanException;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Weigher;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - HTTP Cache - Caffeine In-Memory cache store", description="Cache data store implementation for storage using Caffeine cache. The 3rd-party Caffeine OSGi bundle MUST be installed and active before the OSGi service is enabled.", metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="httpcache.cachestore.type", value={"CAFFEINE"}, propertyPrivate=true), @Property(name="jmx.objectname", value={"com.adobe.acs.commons.httpcache:type=HTTP Cache - Caffeine Cache Store"}, propertyPrivate=true), @Property(name="webconsole.configurationFactory.nameHint", value={"TTL: {httpcache.cachestore.caffeine.ttl}, Max size in MB: {httpcache.cachestore.caffeine.maxsize}"}, propertyPrivate=true)})
@Service(value={HttpCacheStore.class})
public class CaffeineMemHttpCacheStoreImpl
extends AbstractCaffeineCacheMBean<CacheKey, MemCachePersistenceObject>
implements HttpCacheStore,
CaffeineCacheMBean {
    private static final Logger log = LoggerFactory.getLogger(CaffeineMemHttpCacheStoreImpl.class);
    private static final long DEFAULT_TTL = -1L;
    @Property(label="TTL", description="TTL for all entries in this cache in seconds. Default to -1 meaning no TTL.", longValue={-1L})
    private static final String PROP_TTL = "httpcache.cachestore.caffeine.ttl";
    private long ttl;
    private static final long DEFAULT_MAX_SIZE_IN_MB = 10L;
    @Property(label="Maximum size of this store in MB", description="Default to 10MB. If cache size goes beyond this size, least used entry will be evicted from the cache", longValue={10L})
    private static final String PROP_MAX_SIZE_IN_MB = "httpcache.cachestore.caffeine.maxsize";
    private long maxSizeInMb;
    private static final long MEGABYTE = 0x100000L;
    protected static final int NANOSECOND_MODIFIER = 1000000;
    private Cache<CacheKey, MemCachePersistenceObject> cache;
    private Expiry<CacheKey, MemCachePersistenceObject> expiryPolicy;

    @Activate
    protected void activate(Map<String, Object> config) {
        this.ttl = PropertiesUtil.toLong((Object)config.get(PROP_TTL), (long)-1L);
        this.maxSizeInMb = PropertiesUtil.toLong((Object)config.get(PROP_MAX_SIZE_IN_MB), (long)10L);
        this.expiryPolicy = new CacheExpiryPolicy(this.ttl);
        this.deactivate();
        try {
            this.cache = this.buildCache();
        }
        catch (Exception e) {
            log.error("The 3rd-party Caffeine OSGi bundle must be installed and active for this OSGi service to be used. Please disable this OSGi service until the required Caffeine OSGi bundle is installed", (Throwable)e);
            throw e;
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.cache != null) {
            this.cache.invalidateAll();
        }
    }

    private Cache<CacheKey, MemCachePersistenceObject> buildCache() {
        return Caffeine.newBuilder().maximumWeight(this.maxSizeInMb * 0x100000L).weigher((Weigher)new MemCacheEntryWeigher()).expireAfter(this.expiryPolicy).removalListener((RemovalListener)new MemCacheEntryRemovalListener()).recordStats().build();
    }

    public CaffeineMemHttpCacheStoreImpl() throws NotCompliantMBeanException {
        super(CaffeineCacheMBean.class);
    }

    @Override
    public long getTtl() {
        return this.ttl;
    }

    @Override
    protected long getBytesLength(MemCachePersistenceObject cacheObj) {
        return cacheObj.getBytes().length;
    }

    @Override
    protected void addCacheData(Map<String, Object> data, MemCachePersistenceObject cacheObj) {
        int hitCount = cacheObj.getHitCount();
        long size = cacheObj.getBytes().length;
        data.put("Status", cacheObj.getStatus());
        data.put("Size", FileUtils.byteCountToDisplaySize((long)size));
        data.put("Content Type", cacheObj.getContentType());
        data.put("Character Encoding", cacheObj.getCharEncoding());
        data.put("Hits", hitCount);
        data.put("Total Size Served from Cache", FileUtils.byteCountToDisplaySize((long)((long)hitCount * size)));
    }

    @Override
    protected String toString(MemCachePersistenceObject cacheObj) throws CacheMBeanException {
        try {
            return IOUtils.toString((InputStream)new ByteArrayInputStream(cacheObj.getBytes()), (String)cacheObj.getCharEncoding());
        }
        catch (IOException e) {
            throw new CacheMBeanException("Error getting the content from the cacheObject", e);
        }
    }

    @Override
    protected CompositeType getCacheEntryType() throws OpenDataException {
        return new CompositeType("Cache Entry", "Cache Entry", new String[]{"Cache Key", "Status", "Size", "Content Type", "Character Encoding", "Hits", "Total Size Served from Cache"}, new String[]{"Cache Key", "Status", "Size", "Content Type", "Character Encoding", "Hits", "Total Size Served from Cache"}, new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING});
    }

    @Override
    protected Cache<CacheKey, MemCachePersistenceObject> getCache() {
        return this.cache;
    }

    @Override
    public void put(CacheKey key, CacheContent content) throws HttpCacheDataStreamException {
        this.cache.put((Object)key, (Object)new MemCachePersistenceObject().buildForCaching(content.getStatus(), content.getCharEncoding(), content.getContentType(), content.getHeaders(), content.getInputDataStream(), content.getWriteMethod()));
    }

    @Override
    public boolean contains(CacheKey key) {
        return null != this.cache.getIfPresent((Object)key);
    }

    @Override
    public CacheContent getIfPresent(CacheKey key) {
        MemCachePersistenceObject value = (MemCachePersistenceObject)this.cache.getIfPresent((Object)key);
        if (null == value) {
            return null;
        }
        value.incrementHitCount();
        return new CacheContent(value.getStatus(), value.getCharEncoding(), value.getContentType(), value.getHeaders(), new ByteArrayInputStream(value.getBytes()));
    }

    @Override
    public long size() {
        return this.cache.estimatedSize();
    }

    @Override
    public void invalidate(CacheKey invalidationKey) {
        ConcurrentMap cacheAsMap = this.cache.asMap();
        for (CacheKey key : cacheAsMap.keySet()) {
            if (!key.isInvalidatedBy(invalidationKey)) continue;
            this.cache.invalidate((Object)key);
        }
    }

    @Override
    public void invalidate(HttpCacheConfig cacheConfig) {
        ConcurrentMap cacheAsMap = this.cache.asMap();
        for (CacheKey key : cacheAsMap.keySet()) {
            try {
                if (!cacheConfig.knows(key)) continue;
                this.cache.invalidate((Object)key);
            }
            catch (HttpCacheKeyCreationException e) {
                log.error("Could not invalidate HTTP cache. Falling back to full cache invalidation.", (Throwable)e);
                this.invalidateAll();
            }
        }
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public TempSink createTempSink() {
        return new MemTempSinkImpl();
    }

    @Override
    public String getStoreType() {
        return "CAFFEINE";
    }

    private static class MemCacheEntryWeigher
    implements Weigher<CacheKey, MemCachePersistenceObject> {
        private MemCacheEntryWeigher() {
        }

        public int weigh(CacheKey memCacheKey, MemCachePersistenceObject memCachePersistenceObject) {
            return memCachePersistenceObject.getBytes().length;
        }
    }

    private static class MemCacheEntryRemovalListener
    implements RemovalListener<CacheKey, MemCachePersistenceObject> {
        private MemCacheEntryRemovalListener() {
        }

        public void onRemoval(CacheKey cacheKey, MemCachePersistenceObject memCachePersistenceObject, RemovalCause removalCause) {
        }
    }
}

