/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfigExtension;
import com.adobe.acs.commons.httpcache.config.impl.keys.RequestPathCacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKeyFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={HttpCacheConfigExtension.class, CacheKeyFactory.class}, property={"service.ranking:Integer=40"})
@Designate(ocd=Config.class, factory=true)
public class RequestPathHttpCacheConfigExtension
implements HttpCacheConfigExtension,
CacheKeyFactory {
    private static final Logger log = LoggerFactory.getLogger(RequestPathHttpCacheConfigExtension.class);
    protected List<Pattern> resourcePathPatterns;
    protected List<Pattern> selectorPatterns;
    protected List<Pattern> extensionPatterns;
    protected String configName;

    @Override
    public boolean accepts(SlingHttpServletRequest request, HttpCacheConfig cacheConfig) {
        RequestPathInfo requestPathInfo = request.getRequestPathInfo();
        boolean match = this.matches(this.resourcePathPatterns, requestPathInfo.getResourcePath()) && this.matches(this.selectorPatterns, requestPathInfo.getSelectorString()) && this.matches(this.extensionPatterns, requestPathInfo.getExtension());
        log.debug("Extension {} : Passed : {} for {}", new Object[]{this.configName, match, requestPathInfo.getResourcePath()});
        return match;
    }

    protected boolean matches(List<Pattern> patternList, String query) {
        if (CollectionUtils.isEmpty(patternList)) {
            log.debug("Extension {} : Non defined patternList {} : skipping check for query: {}", new Object[]{this.configName, patternList, query});
            return true;
        }
        if (CollectionUtils.isNotEmpty(patternList) && StringUtils.isNotBlank((CharSequence)query)) {
            for (Pattern pattern : patternList) {
                if (!pattern.matcher(query).find()) continue;
                log.debug("Extension {} : Passed all patterns: {} for query: {}", new Object[]{this.configName, patternList, query});
                return true;
            }
        }
        return false;
    }

    @Override
    public CacheKey build(SlingHttpServletRequest slingHttpServletRequest, HttpCacheConfig cacheConfig) {
        return new RequestPathCacheKey(slingHttpServletRequest, cacheConfig);
    }

    @Override
    public CacheKey build(String resourcePath, HttpCacheConfig httpCacheConfig) {
        return new RequestPathCacheKey(resourcePath, httpCacheConfig);
    }

    @Override
    public boolean doesKeyMatchConfig(CacheKey key, HttpCacheConfig cacheConfig) {
        if (!(key instanceof RequestPathCacheKey)) {
            return false;
        }
        RequestPathCacheKey thatKey = (RequestPathCacheKey)key;
        return new RequestPathCacheKey(thatKey.getUri(), cacheConfig).equals(key);
    }

    @Activate
    protected void activate(Config config) {
        this.configName = config.config_name();
        this.resourcePathPatterns = this.compileToPatterns(config.httpcache_config_extension_paths_allowed());
        this.extensionPatterns = this.compileToPatterns(config.httpcache_config_extension_extensions_allowed());
        this.selectorPatterns = this.compileToPatterns(config.httpcache_config_extension_selectors_allowed());
    }

    protected List<Pattern> compileToPatterns(String[] regexes) {
        if (ArrayUtils.isEmpty((Object[])regexes)) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String regex : regexes) {
            if (!StringUtils.isNotBlank((CharSequence)regex)) continue;
            patterns.add(Pattern.compile(regex));
        }
        return patterns;
    }

    @ObjectClassDefinition(name="ACS AEM Commons - HTTP Cache - Extension - Request Path", description="Extension for the ACS commons HTTP Cache. Based on request path info ( resource path, selectors, extensions )")
    public static @interface Config {
        @AttributeDefinition(name="Configuration Name", description="The unique identifier of this extension")
        public String config_name() default "";

        @AttributeDefinition(name="Resource path patterns", description="List of resource path patterns (regex) that will be valid for caching")
        public String[] httpcache_config_extension_paths_allowed();

        @AttributeDefinition(name="Selector patterns", description="List of selector patterns (regex) that will be valid for caching")
        public String[] httpcache_config_extension_selectors_allowed();

        @AttributeDefinition(name="Extension patterns", description="List of extension patterns (regex) that will be valid for caching")
        public String[] httpcache_config_extension_extensions_allowed();

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "Config name: [ {config.name}  RequestPath: [ {httpcache.config.extension.paths.allowed}]";
    }
}

