/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.analysis.jcrchecksum.impl.servlets;

import com.adobe.acs.commons.analysis.jcrchecksum.ChecksumGeneratorOptions;
import com.adobe.acs.commons.analysis.jcrchecksum.impl.JSONGenerator;
import com.adobe.acs.commons.analysis.jcrchecksum.impl.options.ChecksumGeneratorOptionsFactory;
import com.adobe.acs.commons.analysis.jcrchecksum.impl.options.RequestChecksumGeneratorOptions;
import com.adobe.acs.commons.analysis.jcrchecksum.impl.servlets.BaseChecksumServlet;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Properties(value={@Property(name="sling.servlet.paths", value={"/bin/acs-commons/jcr-compare.dump.json"}), @Property(name="sling.auth.requirements", value={"-/bin/acs-commons/jcr-compare.dump.json"})})
@Service
public class JSONDumpServlet
extends BaseChecksumServlet {
    private static final Logger log = LoggerFactory.getLogger(JSONDumpServlet.class);
    public static final String SERVLET_PATH = "/bin/acs-commons/jcr-compare.dump.json";

    public final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            this.handleCORS(request, response);
            this.handleRequest(request, response);
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            this.handleCORS(request, response);
            this.handleRequest(request, response);
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void handleRequest(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, RepositoryException, ServletException {
        Set<String> paths;
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        SimpleDateFormat df = new SimpleDateFormat("yyyyddMM_HHmmss");
        Date today = Calendar.getInstance().getTime();
        String filename = df.format(today);
        response.setHeader("Content-Disposition", "filename=jcr-checksum-" + filename + ".json");
        String optionsName = request.getParameter("optionsName");
        ChecksumGeneratorOptions options = ChecksumGeneratorOptionsFactory.getOptions(request, optionsName);
        if (log.isDebugEnabled()) {
            log.debug(options.toString());
        }
        if (CollectionUtils.isEmpty(paths = RequestChecksumGeneratorOptions.getPaths(request))) {
            response.setStatus(400);
            response.getWriter().print("ERROR: At least one path must be specified");
        } else {
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            JsonWriter jsonWriter = new JsonWriter((Writer)response.getWriter());
            try {
                JSONGenerator.generateJSON(session, paths, options, jsonWriter);
                jsonWriter.close();
            }
            catch (RepositoryException e) {
                throw new ServletException("Error accessing repository", (Throwable)e);
            }
            catch (IOException e) {
                throw new ServletException("Unable to generate json", (Throwable)e);
            }
        }
    }
}

