/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.common.testhelpers;

import fiftyone.common.testhelpers.TestLogger;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public final class TestLoggerFactory
implements ILoggerFactory {
    private final ILoggerFactory internalLoggerFactory;
    public List<TestLogger> loggers = new ArrayList<TestLogger>();

    public TestLoggerFactory(ILoggerFactory internalLoggerFactory) {
        this.internalLoggerFactory = internalLoggerFactory;
    }

    public Logger getLogger(String name) {
        TestLogger logger = new TestLogger(name, this.internalLoggerFactory == null ? null : this.internalLoggerFactory.getLogger(name));
        this.loggers.add(logger);
        return logger;
    }

    public void assertMaxWarnings(int count) {
        ArrayList<String> warningsLogged = new ArrayList<String>();
        for (TestLogger logger : this.loggers) {
            warningsLogged.addAll(logger.warningsLogged);
        }
        if (warningsLogged.size() > count) {
            String message = warningsLogged.size() + " warnings occurred during test " + (count > 0 ? "expected no more than " + count : " ") + ":";
            for (String warning : warningsLogged) {
                message = message + "\n";
                message = message + "\n";
                message = message + warning;
            }
            Assert.fail((String)message);
        }
    }

    public void assertMaxErrors(int count) {
        ArrayList<String> errorsLogged = new ArrayList<String>();
        for (TestLogger logger : this.loggers) {
            errorsLogged.addAll(logger.errorsLogged);
        }
        if (errorsLogged.size() > count) {
            String message = errorsLogged.size() + " errors occurred during test " + (count > 0 ? "expected no more than " + count : " ") + ":";
            for (String warning : errorsLogged) {
                message = message + "\n";
                message = message + "\n";
                message = message + warning;
            }
            Assert.fail((String)message);
        }
    }
}

