/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.common.testhelpers;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class TestLogger
implements Logger {
    private final Logger internalLogger;
    private final String name;
    public List<String> warningsLogged = new ArrayList<String>();
    public List<String> errorsLogged = new ArrayList<String>();

    public TestLogger(String name, Logger internalLogger) {
        this.name = name;
        this.internalLogger = internalLogger;
    }

    public void assertMaxWarnings(int count) {
        if (this.warningsLogged.size() > count) {
            String message = this.warningsLogged.size() + " warnings occurred during test " + (count > 0 ? "expected no more than " + count : " ") + ":";
            for (String warning : this.warningsLogged) {
                message = message + "\n";
                message = message + "\n";
                message = message + warning;
            }
            Assert.fail((String)message);
        }
    }

    public void assertMaxErrors(int count) {
        if (this.errorsLogged.size() > count) {
            String message = this.errorsLogged.size() + " errors occurred during test " + (count > 0 ? "expected no more than " + count : " ") + ":";
            for (String error : this.errorsLogged) {
                message = message + "\n";
                message = message + "\n";
                message = message + error;
            }
            Assert.fail((String)message);
        }
    }

    public String getName() {
        return this.internalLogger == null ? this.name : this.internalLogger.getName();
    }

    public boolean isTraceEnabled() {
        return this.internalLogger != null && this.internalLogger.isTraceEnabled();
    }

    public void trace(String msg) {
        if (this.internalLogger != null) {
            this.internalLogger.trace(msg);
        }
    }

    public void trace(String format, Object arg) {
        if (this.internalLogger != null) {
            this.internalLogger.trace(format, arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.internalLogger != null) {
            this.internalLogger.trace(format, arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.internalLogger != null) {
            this.internalLogger.trace(format, arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.internalLogger != null) {
            this.internalLogger.trace(msg, t);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.internalLogger != null && this.internalLogger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        if (this.internalLogger != null) {
            this.internalLogger.trace(marker, msg);
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.internalLogger != null) {
            this.internalLogger.trace(marker, format, arg);
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.internalLogger != null) {
            this.internalLogger.trace(marker, format, arg1, arg2);
        }
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.internalLogger != null) {
            this.internalLogger.trace(marker, format, argArray);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.internalLogger != null) {
            this.internalLogger.trace(marker, msg, t);
        }
    }

    public boolean isDebugEnabled() {
        return this.internalLogger != null && this.internalLogger.isDebugEnabled();
    }

    public void debug(String msg) {
        if (this.internalLogger != null) {
            this.internalLogger.debug(msg);
        }
    }

    public void debug(String format, Object arg) {
        if (this.internalLogger != null) {
            this.internalLogger.debug(format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.internalLogger != null) {
            this.internalLogger.debug(format, arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.internalLogger != null) {
            this.internalLogger.debug(format, arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.internalLogger != null) {
            this.internalLogger.debug(msg, t);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.internalLogger != null && this.internalLogger.isDebugEnabled();
    }

    public void debug(Marker marker, String msg) {
        if (this.internalLogger != null) {
            this.internalLogger.debug(marker, msg);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.internalLogger != null) {
            this.internalLogger.debug(marker, format, arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.internalLogger != null) {
            this.internalLogger.debug(marker, format, arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.internalLogger != null) {
            this.internalLogger.debug(marker, format, arguments);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.internalLogger != null) {
            this.internalLogger.debug(marker, msg, t);
        }
    }

    public boolean isInfoEnabled() {
        return this.internalLogger != null && this.internalLogger.isInfoEnabled();
    }

    public void info(String msg) {
        if (this.internalLogger != null) {
            this.internalLogger.info(msg);
        }
    }

    public void info(String format, Object arg) {
        if (this.internalLogger != null) {
            this.internalLogger.info(format, arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.internalLogger != null) {
            this.internalLogger.info(format, arg1, arg2);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.internalLogger != null) {
            this.internalLogger.info(format, arguments);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.internalLogger != null) {
            this.internalLogger.info(msg, t);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.internalLogger != null && this.internalLogger.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        if (this.internalLogger != null) {
            this.internalLogger.info(marker, msg);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.internalLogger != null) {
            this.internalLogger.info(marker, format, arg);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.internalLogger != null) {
            this.internalLogger.info(marker, format, arg1, arg2);
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (this.internalLogger != null) {
            this.internalLogger.info(marker, format, arguments);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.internalLogger != null) {
            this.internalLogger.info(marker, msg, t);
        }
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        this.warningsLogged.add(msg);
        if (this.internalLogger != null && this.internalLogger.isWarnEnabled()) {
            this.internalLogger.warn(msg);
        }
    }

    public void warn(String format, Object arg) {
        this.warningsLogged.add(String.format(format, arg));
        if (this.internalLogger != null && this.internalLogger.isWarnEnabled()) {
            this.internalLogger.warn(format, arg);
        }
    }

    public void warn(String format, Object ... arguments) {
        this.warningsLogged.add(String.format(format, arguments));
        if (this.internalLogger != null && this.internalLogger.isWarnEnabled()) {
            this.internalLogger.warn(format, arguments);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.warningsLogged.add(String.format(format, arg1, arg2));
        if (this.internalLogger != null && this.internalLogger.isWarnEnabled()) {
            this.internalLogger.warn(format, arg1, arg2);
        }
    }

    public void warn(String msg, Throwable t) {
        this.warningsLogged.add(msg);
        if (this.internalLogger != null && this.internalLogger.isWarnEnabled()) {
            this.internalLogger.warn(msg, t);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return true;
    }

    public void warn(Marker marker, String msg) {
        this.warningsLogged.add(msg);
        if (this.internalLogger != null && this.internalLogger.isWarnEnabled(marker)) {
            this.internalLogger.warn(marker, msg);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warningsLogged.add(String.format(format, arg));
        if (this.internalLogger != null && this.internalLogger.isWarnEnabled(marker)) {
            this.internalLogger.warn(marker, format, arg);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warningsLogged.add(String.format(format, arg1, arg2));
        if (this.internalLogger != null && this.internalLogger.isWarnEnabled(marker)) {
            this.internalLogger.warn(marker, format, arg1, arg2);
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.warningsLogged.add(String.format(format, arguments));
        if (this.internalLogger != null && this.internalLogger.isWarnEnabled(marker)) {
            this.internalLogger.warn(marker, format, arguments);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.warningsLogged.add(msg);
        if (this.internalLogger != null && this.internalLogger.isWarnEnabled(marker)) {
            this.internalLogger.warn(marker, msg, t);
        }
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        this.errorsLogged.add(msg);
        if (this.internalLogger != null && this.internalLogger.isErrorEnabled()) {
            this.internalLogger.error(msg);
        }
    }

    public void error(String format, Object arg) {
        this.errorsLogged.add(String.format(format, arg));
        if (this.internalLogger != null && this.internalLogger.isErrorEnabled()) {
            this.internalLogger.error(format, arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        this.errorsLogged.add(String.format(format, arg1, arg2));
        if (this.internalLogger != null && this.internalLogger.isErrorEnabled()) {
            this.internalLogger.error(format, arg1, arg2);
        }
    }

    public void error(String format, Object ... arguments) {
        this.errorsLogged.add(String.format(format, arguments));
        if (this.internalLogger != null && this.internalLogger.isErrorEnabled()) {
            this.internalLogger.error(format, arguments);
        }
    }

    public void error(String msg, Throwable t) {
        this.errorsLogged.add(msg);
        if (this.internalLogger != null && this.internalLogger.isErrorEnabled()) {
            this.internalLogger.error(msg, t);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return true;
    }

    public void error(Marker marker, String msg) {
        this.errorsLogged.add(msg);
        if (this.internalLogger != null && this.internalLogger.isErrorEnabled(marker)) {
            this.internalLogger.error(marker, msg);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        this.errorsLogged.add(String.format(format, arg));
        if (this.internalLogger != null && this.internalLogger.isErrorEnabled(marker)) {
            this.internalLogger.error(marker, format, arg);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.errorsLogged.add(String.format(format, arg1, arg2));
        if (this.internalLogger != null && this.internalLogger.isErrorEnabled(marker)) {
            this.internalLogger.error(marker, format, arg1, arg2);
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.errorsLogged.add(String.format(format, arguments));
        if (this.internalLogger != null && this.internalLogger.isErrorEnabled(marker)) {
            this.internalLogger.error(marker, format, arguments);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.errorsLogged.add(msg);
        if (this.internalLogger != null && this.internalLogger.isErrorEnabled(marker)) {
            this.internalLogger.error(marker, msg, t);
        }
    }
}

