/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.common.testhelpers;

import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@RunListener.ThreadSafe
public class MavenRunListener
extends RunListener {
    static Logger logger = LoggerFactory.getLogger(MavenRunListener.class);
    static Marker marker = MarkerFactory.getMarker((String)"Starting Test");
    static Marker endMarker = MarkerFactory.getMarker((String)"Finished Test");
    static Marker failMarker = MarkerFactory.getMarker((String)"Failed Test");
    static Marker assumeFailMarker = MarkerFactory.getMarker((String)"Assumption Failed");
    static Marker ignoredMarker = MarkerFactory.getMarker((String)"Ignored Test");

    public void testStarted(Description description) throws Exception {
        super.testStarted(description);
        logger.info(marker, "{}", (Object)description.getDisplayName());
    }

    public void testFailure(Failure failure) throws Exception {
        super.testFailure(failure);
        logger.error(failMarker, "{} {}", (Object)failure.getMessage(), (Object)failure.getDescription().getDisplayName());
    }

    public void testAssumptionFailure(Failure failure) {
        super.testAssumptionFailure(failure);
        logger.warn(assumeFailMarker, "{} {}", (Object)failure.getMessage(), (Object)failure.getDescription().getDisplayName());
    }

    public void testIgnored(Description description) throws Exception {
        super.testIgnored(description);
        logger.info(ignoredMarker, "{}", (Object)description.getDisplayName());
    }

    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        logger.info(endMarker, "Finished {}", (Object)description.getDisplayName());
    }
}

